/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.codec.xml.RandomPrefix;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.data.util.codec.IdentityCodecUtil;
import org.opendaylight.yangtools.yang.data.util.codec.QNameCodecUtil;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

final class IdentityrefXmlCodec
implements XmlCodec<QName> {
    private final SchemaContext schemaContext;
    private final QNameModule parentModule;

    IdentityrefXmlCodec(SchemaContext context, QNameModule parentModule) {
        this.schemaContext = Objects.requireNonNull(context);
        this.parentModule = Objects.requireNonNull(parentModule);
    }

    public Class<QName> getDataType() {
        return QName.class;
    }

    public QName parseValue(NamespaceContext ctx, String str) {
        return IdentityCodecUtil.parseIdentity((String)str, (SchemaContext)this.schemaContext, prefix -> {
            if (prefix.isEmpty()) {
                return this.parentModule;
            }
            String prefixedNS = ctx.getNamespaceURI((String)prefix);
            Iterator modules = this.schemaContext.findModules(URI.create(prefixedNS)).iterator();
            Preconditions.checkArgument((boolean)modules.hasNext(), (String)"Could not find module for namespace %s", (Object)prefixedNS);
            return ((Module)modules.next()).getQNameModule();
        }).getQName();
    }

    @Override
    public void writeValue(XMLStreamWriter ctx, QName value) throws XMLStreamException {
        RandomPrefix prefixes = new RandomPrefix(ctx.getNamespaceContext());
        String str = QNameCodecUtil.encodeQName((QName)value, uri -> prefixes.encodePrefix(uri.getNamespace()));
        for (Map.Entry<URI, String> e : prefixes.getPrefixes()) {
            ctx.writeNamespace(e.getValue(), e.getKey().toString());
        }
        ctx.writeCharacters(str);
    }
}

