/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.SchemaAwareXMLStreamWriterUtils;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.codec.SchemaTracker;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

final class SchemaAwareXMLStreamNormalizedNodeStreamWriter
extends XMLStreamNormalizedNodeStreamWriter<SchemaNode>
implements SchemaContextProvider {
    private final SchemaTracker tracker;
    private final SchemaAwareXMLStreamWriterUtils streamUtils;

    SchemaAwareXMLStreamNormalizedNodeStreamWriter(XMLStreamWriter writer, SchemaContext context, SchemaTracker tracker) {
        super(writer);
        this.tracker = Objects.requireNonNull(tracker);
        this.streamUtils = new SchemaAwareXMLStreamWriterUtils(context);
    }

    @Override
    void writeValue(ValueWriter xmlWriter, QName qname, Object value, SchemaNode schemaNode) throws XMLStreamException {
        this.streamUtils.writeValue(xmlWriter, schemaNode, value, qname.getModule());
    }

    @Override
    void startList(YangInstanceIdentifier.NodeIdentifier name) {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
    }

    @Override
    void startListItem(YangInstanceIdentifier.PathArgument name) throws IOException {
        this.tracker.startListItem(name);
        this.startElement(name.getNodeType());
    }

    public void endNode() throws IOException {
        Object schema = this.tracker.endNode();
        if (schema instanceof ListSchemaNode) {
            Object parent = this.tracker.getParent();
            if (parent == schema) {
                this.endElement();
            }
        } else if (schema instanceof ContainerSchemaNode) {
            this.endElement();
        }
    }

    public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException {
        LeafSchemaNode schema = this.tracker.leafNode(name);
        this.writeElement(schema.getQName(), value, Collections.emptyMap(), schema);
    }

    public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value, Map<QName, String> attributes) throws IOException {
        LeafSchemaNode schema = this.tracker.leafNode(name);
        this.writeElement(schema.getQName(), value, attributes, schema);
    }

    public void leafSetEntryNode(QName name, Object value, Map<QName, String> attributes) throws IOException {
        LeafListSchemaNode schema = this.tracker.leafSetEntryNode(name);
        this.writeElement(schema.getQName(), value, attributes, schema);
    }

    public void leafSetEntryNode(QName name, Object value) throws IOException {
        LeafListSchemaNode schema = this.tracker.leafSetEntryNode(name);
        this.writeElement(schema.getQName(), value, Collections.emptyMap(), schema);
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startLeafSet(name);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startLeafSet(name);
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        SchemaNode schema = this.tracker.startContainerNode(name);
        this.startElement(schema.getQName());
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startChoiceNode(name);
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        this.tracker.startAugmentationNode(identifier);
    }

    public void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        SchemaNode schema = this.tracker.startYangModeledAnyXmlNode(name);
        this.startElement(schema.getQName());
    }

    public void anyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException {
        AnyXmlSchemaNode schema = this.tracker.anyxmlNode(name);
        this.anyxmlNode(schema.getQName(), value);
    }

    public SchemaContext getSchemaContext() {
        return this.streamUtils.getSchemaContext();
    }
}

