/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class XMLStreamWriterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XMLStreamWriterUtils.class);

    XMLStreamWriterUtils() {
    }

    void writeValue(@NonNull ValueWriter writer, @NonNull SchemaNode schemaNode, @NonNull Object value, QNameModule parent) throws XMLStreamException {
        Preconditions.checkArgument((boolean)(schemaNode instanceof TypedDataSchemaNode), (String)"Unable to write value for node %s, only nodes of type: leaf and leaf-list can be written at this point", (Object)schemaNode.getQName());
        TypeDefinition<?> type = ((TypedDataSchemaNode)schemaNode).getType();
        if (type instanceof LeafrefTypeDefinition) {
            type = this.getBaseTypeForLeafRef(schemaNode, (LeafrefTypeDefinition)type);
        }
        this.writeValue(writer, type, value, parent);
    }

    private void writeValue(@NonNull ValueWriter writer, @NonNull TypeDefinition<?> type, @NonNull Object value, QNameModule parent) throws XMLStreamException {
        if (type instanceof IdentityrefTypeDefinition) {
            XMLStreamWriterUtils.write(writer, (IdentityrefTypeDefinition)type, value, parent);
        } else if (type instanceof InstanceIdentifierTypeDefinition) {
            this.write(writer, (InstanceIdentifierTypeDefinition)type, value);
        } else {
            writer.writeCharacters(XMLStreamWriterUtils.serialize(type, value));
        }
    }

    private static String serialize(@NonNull TypeDefinition<?> type, @NonNull Object value) {
        TypeDefinitionAwareCodec codec = TypeDefinitionAwareCodec.from(type);
        if (codec == null) {
            LOG.warn("Failed to find codec for {}, falling back to using stream", type);
            return value.toString();
        }
        try {
            return codec.serialize(value);
        }
        catch (ClassCastException e) {
            LOG.warn("Provided node value {} did not have type {} required by mapping. Using stream instead.", new Object[]{value, type, e});
            return value.toString();
        }
    }

    @VisibleForTesting
    static void write(@NonNull ValueWriter writer, @NonNull IdentityrefTypeDefinition type, @NonNull Object value, QNameModule parent) throws XMLStreamException {
        if (value instanceof QName) {
            QName qname = (QName)value;
            if (qname.getNamespace().equals(parent.getNamespace())) {
                writer.writeCharacters(qname.getLocalName());
            } else {
                String ns = qname.getNamespace().toString();
                String prefix = "x";
                writer.writeNamespace("x", ns);
                writer.writeCharacters("x:" + qname.getLocalName());
            }
        } else {
            QName qname = type.getQName();
            LOG.debug("Value of {}:{} is not a QName but {}", new Object[]{qname.getNamespace(), qname.getLocalName(), value.getClass()});
            writer.writeToStringCharacters(value);
        }
    }

    private void write(@NonNull ValueWriter writer, @NonNull InstanceIdentifierTypeDefinition type, @NonNull Object value) throws XMLStreamException {
        if (value instanceof YangInstanceIdentifier) {
            this.writeInstanceIdentifier(writer, (YangInstanceIdentifier)value);
        } else {
            QName qname = type.getQName();
            LOG.warn("Value of {}:{} is not an InstanceIdentifier but {}", new Object[]{qname.getNamespace(), qname.getLocalName(), value.getClass()});
            writer.writeToStringCharacters(value);
        }
    }

    abstract @NonNull TypeDefinition<?> getBaseTypeForLeafRef(SchemaNode var1, @NonNull LeafrefTypeDefinition var2);

    abstract void writeInstanceIdentifier(@NonNull ValueWriter var1, YangInstanceIdentifier var2) throws XMLStreamException;
}

