/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.parser.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;

@Beta
@NotThreadSafe
public interface YangParser {
    public Collection<Class<? extends SchemaSourceRepresentation>> supportedSourceRepresentations();

    public Set<QName> supportedStatements();

    public YangParser addSource(SchemaSourceRepresentation var1) throws IOException, YangSyntaxErrorException;

    default public YangParser addSources(SchemaSourceRepresentation ... sources) throws IOException, YangSyntaxErrorException {
        for (SchemaSourceRepresentation source : sources) {
            this.addSource(source);
        }
        return this;
    }

    default public YangParser addSources(Collection<? extends SchemaSourceRepresentation> sources) throws IOException, YangSyntaxErrorException {
        for (SchemaSourceRepresentation schemaSourceRepresentation : sources) {
            this.addSource(schemaSourceRepresentation);
        }
        return this;
    }

    public YangParser addLibSource(SchemaSourceRepresentation var1) throws IOException, YangSyntaxErrorException;

    default public YangParser addLibSources(SchemaSourceRepresentation ... sources) throws IOException, YangSyntaxErrorException {
        for (SchemaSourceRepresentation source : sources) {
            this.addLibSource(source);
        }
        return this;
    }

    default public YangParser addLibSources(Collection<SchemaSourceRepresentation> sources) throws IOException, YangSyntaxErrorException {
        for (SchemaSourceRepresentation source : sources) {
            this.addLibSource(source);
        }
        return this;
    }

    public YangParser setSupportedFeatures(@NonNull Set<QName> var1);

    public YangParser setModulesWithSupportedDeviations(@NonNull SetMultimap<QNameModule, QNameModule> var1);

    public List<DeclaredStatement<?>> buildDeclaredModel() throws YangParserException;

    default public Map<QNameModule, ModuleEffectiveStatement> buildEffectiveModel() throws YangParserException {
        throw new UnsupportedOperationException(this.getClass() + " does not implement buildEffectiveModel()");
    }

    public SchemaContext buildSchemaContext() throws YangParserException;
}

