/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.antlr;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@NonNullByDefault
@NotThreadSafe
public abstract class AbstractParserErrorListener<E extends Exception>
extends BaseErrorListener
implements Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractParserErrorListener.class);
    private final List<E> exceptions = new ArrayList();

    public final void syntaxError(@Nullable Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @Nullable String msg, @Nullable RecognitionException e) {
        LOG.debug("Syntax error at {}:{}: {}", new Object[]{line, charPositionInLine, msg, e});
        this.exceptions.add(Verify.verifyNotNull(this.createException((Recognizer)Verify.verifyNotNull(recognizer), offendingSymbol, line, charPositionInLine, (String)Verify.verifyNotNull((Object)msg), e)));
    }

    public final void validate() throws E {
        if (!this.exceptions.isEmpty()) {
            Iterator<Exception> it = this.exceptions.iterator();
            Exception exception = (Exception)it.next();
            it.forEachRemaining(exception::addSuppressed);
            throw exception;
        }
    }

    protected abstract E createException(Recognizer<?, ?> var1, @Nullable Object var2, int var3, int var4, String var5, @Nullable RecognitionException var6);
}

