/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.antlr;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.parser.rfc7950.antlr.AbstractParserErrorListener;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@Beta
@NonNullByDefault
@NotThreadSafe
public final class SourceExceptionParser {
    private SourceExceptionParser() {
    }

    public static <T> T parse(Recognizer<?, ?> recognizer, Supplier<T> parseMethod, StatementSourceReference ref) {
        Listener listener = new Listener(ref);
        recognizer.removeErrorListeners();
        recognizer.addErrorListener((ANTLRErrorListener)listener);
        T ret = parseMethod.get();
        listener.validate();
        return ret;
    }

    public static <T> T parse(Lexer lexer, Parser parser, Supplier<T> parseMethod, StatementSourceReference ref) {
        Listener listener = new Listener(ref);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        T ret = parseMethod.get();
        listener.validate();
        return ret;
    }

    private static final class Listener
    extends AbstractParserErrorListener<SourceException> {
        private final StatementSourceReference ref;

        private Listener(StatementSourceReference ref) {
            this.ref = Objects.requireNonNull(ref);
        }

        @Override
        protected SourceException createException(Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, String msg, @Nullable RecognitionException cause) {
            return new SourceException(this.ref, (Throwable)cause, "%s at %s:%s", new Object[]{msg, line, charPositionInLine});
        }
    }
}

