/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.antlrv4.code.gen.YangStatementParser;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigStatements;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ArgumentContextUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.source.DeclarationInTextSource;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public abstract class YangModelDependencyInfo {
    private static final String BELONGS_TO = YangStmtMapping.BELONGS_TO.getStatementName().getLocalName();
    private static final String IMPORT = YangStmtMapping.IMPORT.getStatementName().getLocalName();
    private static final String INCLUDE = YangStmtMapping.INCLUDE.getStatementName().getLocalName();
    private static final String MODULE = YangStmtMapping.MODULE.getStatementName().getLocalName();
    private static final String REVISION = YangStmtMapping.REVISION.getStatementName().getLocalName();
    private static final String REVISION_DATE = YangStmtMapping.REVISION_DATE.getStatementName().getLocalName();
    private static final String SUBMODULE = YangStmtMapping.SUBMODULE.getStatementName().getLocalName();
    private static final String OPENCONFIG_VERSION = OpenConfigStatements.OPENCONFIG_VERSION.getStatementName().getLocalName();
    private static final Splitter COLON_SPLITTER = Splitter.on((String)":").omitEmptyStrings().trimResults();
    private final String name;
    private final Revision revision;
    private final SemVer semVer;
    private final ImmutableSet<ModuleImport> submoduleIncludes;
    private final ImmutableSet<ModuleImport> moduleImports;
    private final ImmutableSet<ModuleImport> dependencies;

    YangModelDependencyInfo(String name, String formattedRevision, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes) {
        this(name, formattedRevision, imports, includes, Optional.empty());
    }

    YangModelDependencyInfo(String name, String formattedRevision, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes, Optional<SemVer> semVer) {
        this.name = name;
        this.revision = Revision.ofNullable((String)formattedRevision).orElse(null);
        this.moduleImports = imports;
        this.submoduleIncludes = includes;
        this.dependencies = ImmutableSet.builder().addAll(this.moduleImports).addAll(this.submoduleIncludes).build();
        this.semVer = semVer.orElse(null);
    }

    public ImmutableSet<ModuleImport> getDependencies() {
        return this.dependencies;
    }

    public String getName() {
        return this.name;
    }

    public String getFormattedRevision() {
        return this.revision != null ? this.revision.toString() : null;
    }

    public Optional<Revision> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    public Optional<SemVer> getSemanticVersion() {
        return Optional.ofNullable(this.semVer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.revision);
        result = 31 * result + Objects.hashCode(this.semVer);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof YangModelDependencyInfo)) {
            return false;
        }
        YangModelDependencyInfo other = (YangModelDependencyInfo)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.revision, other.revision) && Objects.equals(this.semVer, other.semVer);
    }

    static @NonNull YangModelDependencyInfo fromAST(SourceIdentifier source, ParserRuleContext tree) throws YangSyntaxErrorException {
        if (tree instanceof YangStatementParser.StatementContext) {
            YangStatementParser.StatementContext rootStatement = (YangStatementParser.StatementContext)tree;
            return YangModelDependencyInfo.parseAST(rootStatement, source);
        }
        throw new YangSyntaxErrorException(source, 0, 0, "Unknown YANG text type");
    }

    private static @NonNull YangModelDependencyInfo parseAST(YangStatementParser.StatementContext rootStatement, SourceIdentifier source) {
        String keyWordText = rootStatement.keyword().getText();
        if (MODULE.equals(keyWordText)) {
            return YangModelDependencyInfo.parseModuleContext(rootStatement, source);
        }
        if (SUBMODULE.equals(keyWordText)) {
            return YangModelDependencyInfo.parseSubmoduleContext(rootStatement, source);
        }
        throw new IllegalArgumentException("Root of parsed AST must be either module or submodule");
    }

    @VisibleForTesting
    public static YangModelDependencyInfo forResource(Class<?> refClass, String resourceName) throws IOException, YangSyntaxErrorException {
        YangStatementStreamSource source = YangStatementStreamSource.create((YangTextSchemaSource)YangTextSchemaSource.forResource(refClass, (String)resourceName));
        ParserRuleContext ast = source.getYangAST();
        Preconditions.checkArgument((boolean)(ast instanceof YangStatementParser.StatementContext));
        return YangModelDependencyInfo.parseAST((YangStatementParser.StatementContext)ast, source.getIdentifier());
    }

    private static @NonNull YangModelDependencyInfo parseModuleContext(YangStatementParser.StatementContext module, SourceIdentifier source) {
        String name = YangModelDependencyInfo.safeStringArgument(source, module, "module name");
        String latestRevision = YangModelDependencyInfo.getLatestRevision(module, source);
        Optional<SemVer> semVer = Optional.ofNullable(YangModelDependencyInfo.findSemanticVersion(module, source));
        ImmutableSet<ModuleImport> imports = YangModelDependencyInfo.parseImports(module, source);
        ImmutableSet<ModuleImport> includes = YangModelDependencyInfo.parseIncludes(module, source);
        return new ModuleDependencyInfo(name, latestRevision, imports, includes, semVer);
    }

    private static ImmutableSet<ModuleImport> parseImports(YangStatementParser.StatementContext module, SourceIdentifier source) {
        HashSet<ModuleImportImpl> result = new HashSet<ModuleImportImpl>();
        for (YangStatementParser.StatementContext subStatementContext : module.statement()) {
            if (!IMPORT.equals(subStatementContext.keyword().getText())) continue;
            String importedModuleName = YangModelDependencyInfo.safeStringArgument(source, subStatementContext, "imported module name");
            String revisionDateStr = YangModelDependencyInfo.getRevisionDateString(subStatementContext, source);
            Revision revisionDate = Revision.ofNullable((String)revisionDateStr).orElse(null);
            SemVer importSemVer = YangModelDependencyInfo.findSemanticVersion(subStatementContext, source);
            result.add(new ModuleImportImpl(importedModuleName, revisionDate, importSemVer));
        }
        return ImmutableSet.copyOf(result);
    }

    private static SemVer findSemanticVersion(YangStatementParser.StatementContext statement, SourceIdentifier source) {
        String semVerString = null;
        for (YangStatementParser.StatementContext subStatement : statement.statement()) {
            String subStatementName = YangModelDependencyInfo.trimPrefix(subStatement.keyword().getText());
            if (!OPENCONFIG_VERSION.equals(subStatementName)) continue;
            semVerString = YangModelDependencyInfo.safeStringArgument(source, subStatement, "version string");
            break;
        }
        return Strings.isNullOrEmpty(semVerString) ? null : SemVer.valueOf(semVerString);
    }

    private static String trimPrefix(String identifier) {
        List namesParts = COLON_SPLITTER.splitToList((CharSequence)identifier);
        if (namesParts.size() == 2) {
            return (String)namesParts.get(1);
        }
        return identifier;
    }

    private static ImmutableSet<ModuleImport> parseIncludes(YangStatementParser.StatementContext module, SourceIdentifier source) {
        HashSet<ModuleImportImpl> result = new HashSet<ModuleImportImpl>();
        for (YangStatementParser.StatementContext subStatementContext : module.statement()) {
            if (!INCLUDE.equals(subStatementContext.keyword().getText())) continue;
            String revisionDateStr = YangModelDependencyInfo.getRevisionDateString(subStatementContext, source);
            String IncludeModuleName = YangModelDependencyInfo.safeStringArgument(source, subStatementContext, "included submodule name");
            Revision revisionDate = Revision.ofNullable((String)revisionDateStr).orElse(null);
            result.add(new ModuleImportImpl(IncludeModuleName, revisionDate));
        }
        return ImmutableSet.copyOf(result);
    }

    private static String getRevisionDateString(YangStatementParser.StatementContext importStatement, SourceIdentifier source) {
        String revisionDateStr = null;
        for (YangStatementParser.StatementContext importSubStatement : importStatement.statement()) {
            if (!REVISION_DATE.equals(importSubStatement.keyword().getText())) continue;
            revisionDateStr = YangModelDependencyInfo.safeStringArgument(source, importSubStatement, "imported module revision-date");
        }
        return revisionDateStr;
    }

    public static String getLatestRevision(YangStatementParser.StatementContext module, SourceIdentifier source) {
        String latestRevision = null;
        for (YangStatementParser.StatementContext subStatementContext : module.statement()) {
            if (!REVISION.equals(subStatementContext.keyword().getText())) continue;
            String currentRevision = YangModelDependencyInfo.safeStringArgument(source, subStatementContext, "revision date");
            if (latestRevision != null && latestRevision.compareTo(currentRevision) >= 0) continue;
            latestRevision = currentRevision;
        }
        return latestRevision;
    }

    private static @NonNull YangModelDependencyInfo parseSubmoduleContext(YangStatementParser.StatementContext submodule, SourceIdentifier source) {
        String name = YangModelDependencyInfo.safeStringArgument(source, submodule, "submodule name");
        String belongsTo = YangModelDependencyInfo.parseBelongsTo(submodule, source);
        String latestRevision = YangModelDependencyInfo.getLatestRevision(submodule, source);
        ImmutableSet<ModuleImport> imports = YangModelDependencyInfo.parseImports(submodule, source);
        ImmutableSet<ModuleImport> includes = YangModelDependencyInfo.parseIncludes(submodule, source);
        return new SubmoduleDependencyInfo(name, latestRevision, belongsTo, imports, includes);
    }

    private static String parseBelongsTo(YangStatementParser.StatementContext submodule, SourceIdentifier source) {
        for (YangStatementParser.StatementContext subStatementContext : submodule.statement()) {
            if (!BELONGS_TO.equals(subStatementContext.keyword().getText())) continue;
            return YangModelDependencyInfo.safeStringArgument(source, subStatementContext, "belongs-to module name");
        }
        return null;
    }

    private static String safeStringArgument(SourceIdentifier source, YangStatementParser.StatementContext stmt, String desc) {
        StatementSourceReference ref = YangModelDependencyInfo.getReference(source, stmt);
        YangStatementParser.ArgumentContext arg = stmt.argument();
        Preconditions.checkArgument((arg != null ? 1 : 0) != 0, (String)"Missing %s at %s", (Object)desc, (Object)ref);
        return ArgumentContextUtils.stringFromStringContext(arg, YangVersion.VERSION_1, ref);
    }

    private static StatementSourceReference getReference(SourceIdentifier source, YangStatementParser.StatementContext context) {
        return DeclarationInTextSource.atPosition((String)source.getName(), (int)context.getStart().getLine(), (int)context.getStart().getCharPositionInLine());
    }

    private static final class ModuleImportImpl
    implements ModuleImport {
        private final Revision revision;
        private final SemVer semVer;
        private final String name;

        ModuleImportImpl(@NonNull String moduleName, @Nullable Revision revision) {
            this(moduleName, revision, null);
        }

        ModuleImportImpl(@NonNull String moduleName, @Nullable Revision revision, @Nullable SemVer semVer) {
            this.name = Objects.requireNonNull(moduleName, "Module name must not be null.");
            this.revision = revision;
            this.semVer = semVer;
        }

        public String getModuleName() {
            return this.name;
        }

        public Optional<Revision> getRevision() {
            return Optional.ofNullable(this.revision);
        }

        public Optional<SemVer> getSemanticVersion() {
            return Optional.ofNullable(this.semVer);
        }

        public String getPrefix() {
            return null;
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getReference() {
            return Optional.empty();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.name);
            result = 31 * result + Objects.hashCode(this.revision);
            result = 31 * result + Objects.hashCode(this.semVer);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModuleImportImpl)) {
                return false;
            }
            ModuleImportImpl other = (ModuleImportImpl)obj;
            return this.name.equals(other.name) && Objects.equals(this.revision, other.revision) && Objects.equals(this.getSemanticVersion(), other.getSemanticVersion());
        }

        public String toString() {
            return "ModuleImportImpl [name=" + this.name + ", revision=" + QName.formattedRevision(Optional.ofNullable(this.revision)) + ", semanticVersion=" + this.semVer + "]";
        }
    }

    public static final class SubmoduleDependencyInfo
    extends YangModelDependencyInfo {
        private final String belongsTo;

        private SubmoduleDependencyInfo(String name, String latestRevision, String belongsTo, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes) {
            super(name, latestRevision, imports, includes);
            this.belongsTo = belongsTo;
        }

        public String getParentModule() {
            return this.belongsTo;
        }

        public String toString() {
            return "Submodule [name=" + this.getName() + ", revision=" + this.getRevision() + ", dependencies=" + this.getDependencies() + "]";
        }
    }

    public static final class ModuleDependencyInfo
    extends YangModelDependencyInfo {
        ModuleDependencyInfo(String name, String latestRevision, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes, Optional<SemVer> semVer) {
            super(name, latestRevision, imports, includes, semVer);
        }

        public String toString() {
            return "Module [name=" + this.getName() + ", revision=" + this.getRevision() + ", semanticVersion=" + this.getSemanticVersion().orElse(null) + ", dependencies=" + this.getDependencies() + "]";
        }
    }
}

