/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import java.util.Optional;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ErrorAppTagEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ErrorMessageEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModifierEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

@Beta
public abstract class AbstractConstraintEffectiveStatement<A, D extends DeclaredStatement<A>>
extends DeclaredEffectiveStatementBase<A, D>
implements ConstraintMetaDefinition {
    private final String description;
    private final String reference;
    private final String errorAppTag;
    private final String errorMessage;
    private final ModifierKind modifier;
    private final A constraints;

    protected AbstractConstraintEffectiveStatement(StmtContext<A, D, ?> ctx) {
        super(ctx);
        String descriptionInit = null;
        String referenceInit = null;
        String errorAppTagInit = null;
        String errorMessageInit = null;
        ModifierKind modifierInit = null;
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof DescriptionEffectiveStatement) {
                descriptionInit = (String)((DescriptionEffectiveStatement)stmt).argument();
            }
            if (stmt instanceof ReferenceEffectiveStatement) {
                referenceInit = (String)((ReferenceEffectiveStatement)stmt).argument();
            }
            if (stmt instanceof ErrorAppTagEffectiveStatement) {
                errorAppTagInit = (String)((ErrorAppTagEffectiveStatement)stmt).argument();
            }
            if (stmt instanceof ErrorMessageEffectiveStatement) {
                errorMessageInit = (String)((ErrorMessageEffectiveStatement)stmt).argument();
            }
            if (!(stmt instanceof ModifierEffectiveStatement)) continue;
            modifierInit = (ModifierKind)((ModifierEffectiveStatement)stmt).argument();
        }
        this.description = descriptionInit;
        this.reference = referenceInit;
        this.errorAppTag = errorAppTagInit;
        this.errorMessage = errorMessageInit;
        this.modifier = modifierInit;
        this.constraints = this.createConstraints(super.argument());
    }

    @Override
    public final A argument() {
        return this.constraints;
    }

    public final boolean isCustomizedStatement() {
        return this.description != null || this.reference != null || this.errorAppTag != null || this.errorMessage != null || this.modifier != null;
    }

    public final Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public final ModifierKind getModifier() {
        return this.modifier;
    }

    public final Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public final Optional<String> getErrorAppTag() {
        return Optional.ofNullable(this.errorAppTag);
    }

    public final Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    protected abstract A createConstraints(A var1);
}

