/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveSchemaNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public abstract class AbstractEffectiveDataSchemaNode<D extends DeclaredStatement<QName>>
extends AbstractEffectiveSchemaNode<D>
implements DataSchemaNode {
    private final RevisionAwareXPath whenCondition;
    private final boolean addedByUses;
    private final boolean configuration;
    private boolean augmenting;

    protected AbstractEffectiveDataSchemaNode(StmtContext<QName, D, ?> ctx) {
        super(ctx);
        this.configuration = ctx.isConfiguration();
        this.whenCondition = this.findFirstEffectiveSubstatementArgument(WhenEffectiveStatement.class).orElse(null);
        CopyHistory originalHistory = ctx.getCopyHistory();
        if (originalHistory.contains(CopyType.ADDED_BY_USES_AUGMENTATION)) {
            this.augmenting = true;
            this.addedByUses = true;
        } else {
            this.augmenting = originalHistory.contains(CopyType.ADDED_BY_AUGMENTATION);
            this.addedByUses = originalHistory.contains(CopyType.ADDED_BY_USES);
        }
    }

    @Deprecated
    public final boolean isAugmenting() {
        return this.augmenting;
    }

    @Deprecated
    public final boolean isAddedByUses() {
        return this.addedByUses;
    }

    public final boolean isConfiguration() {
        return this.configuration;
    }

    public final Optional<RevisionAwareXPath> getWhenCondition() {
        return Optional.ofNullable(this.whenCondition);
    }

    @Deprecated
    public final void resetAugmenting() {
        this.augmenting = false;
    }
}

