/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.reactor.YangValidationBundles;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractSchemaEffectiveDocumentedNode;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.choice.ImplicitCaseSchemaNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.AugmentToChoiceNamespace;

public abstract class AbstractEffectiveDocumentedDataNodeContainer<A, D extends DeclaredStatement<A>>
extends AbstractSchemaEffectiveDocumentedNode<A, D>
implements DataNodeContainer {
    private final ImmutableMap<QName, DataSchemaNode> childNodes;
    private final ImmutableSet<GroupingDefinition> groupings;
    private final ImmutableSet<UsesNode> uses;
    private final ImmutableSet<TypeDefinition<?>> typeDefinitions;
    private final ImmutableSet<DataSchemaNode> publicChildNodes;

    protected AbstractEffectiveDocumentedDataNodeContainer(StmtContext<A, D, ?> ctx) {
        super(ctx);
        LinkedHashMap<QName, ImplicitCaseSchemaNode> mutableChildNodes = new LinkedHashMap<QName, ImplicitCaseSchemaNode>();
        HashSet<GroupingDefinition> mutableGroupings = new HashSet<GroupingDefinition>();
        HashSet<UsesNode> mutableUses = new HashSet<UsesNode>();
        LinkedHashSet<TypeDefinition> mutableTypeDefinitions = new LinkedHashSet<TypeDefinition>();
        LinkedHashSet<ImplicitCaseSchemaNode> mutablePublicChildNodes = new LinkedHashSet<ImplicitCaseSchemaNode>();
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof DataSchemaNode) {
                DataSchemaNode dataSchemaNode = (DataSchemaNode)stmt;
                if (mutableChildNodes.containsKey(dataSchemaNode.getQName())) {
                    throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, stmt);
                }
                if (this instanceof AugmentationSchemaNode && !(stmt instanceof CaseSchemaNode) && !(stmt instanceof ChoiceSchemaNode) && YangValidationBundles.SUPPORTED_CASE_SHORTHANDS.contains(stmt.statementDefinition()) && Boolean.TRUE.equals(ctx.getFromNamespace(AugmentToChoiceNamespace.class, ctx))) {
                    ImplicitCaseSchemaNode caseShorthand = new ImplicitCaseSchemaNode(dataSchemaNode);
                    mutableChildNodes.put(caseShorthand.getQName(), caseShorthand);
                    mutablePublicChildNodes.add(caseShorthand);
                } else {
                    mutableChildNodes.put(dataSchemaNode.getQName(), (ImplicitCaseSchemaNode)dataSchemaNode);
                    mutablePublicChildNodes.add((ImplicitCaseSchemaNode)dataSchemaNode);
                }
            }
            if (stmt instanceof UsesNode) {
                UsesNode usesNode = (UsesNode)stmt;
                if (!mutableUses.contains(usesNode)) {
                    mutableUses.add(usesNode);
                } else {
                    throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, stmt);
                }
            }
            if (stmt instanceof TypedefEffectiveStatement) {
                TypedefEffectiveStatement typeDef = (TypedefEffectiveStatement)stmt;
                TypeDefinition type = typeDef.getTypeDefinition();
                if (!mutableTypeDefinitions.contains(type)) {
                    mutableTypeDefinitions.add(type);
                } else {
                    throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, stmt);
                }
            }
            if (!(stmt instanceof GroupingDefinition)) continue;
            GroupingDefinition grp = (GroupingDefinition)stmt;
            if (!mutableGroupings.contains(grp)) {
                mutableGroupings.add(grp);
                continue;
            }
            throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, stmt);
        }
        this.childNodes = ImmutableMap.copyOf(mutableChildNodes);
        this.groupings = ImmutableSet.copyOf(mutableGroupings);
        this.publicChildNodes = ImmutableSet.copyOf(mutablePublicChildNodes);
        this.typeDefinitions = ImmutableSet.copyOf(mutableTypeDefinitions);
        this.uses = ImmutableSet.copyOf(mutableUses);
    }

    public final Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public final Set<DataSchemaNode> getChildNodes() {
        return this.publicChildNodes;
    }

    public final Set<GroupingDefinition> getGroupings() {
        return this.groupings;
    }

    public final Optional<DataSchemaNode> findDataChildByName(QName name) {
        return Optional.ofNullable(this.childNodes.get((Object)Objects.requireNonNull(name)));
    }

    public Set<UsesNode> getUses() {
        return this.uses;
    }
}

