/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractSchemaEffectiveDocumentedNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public abstract class AbstractEffectiveSchemaNode<D extends DeclaredStatement<QName>>
extends AbstractSchemaEffectiveDocumentedNode<QName, D>
implements SchemaNode {
    private final @NonNull SchemaPath path;
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownNodes;

    protected AbstractEffectiveSchemaNode(StmtContext<QName, D, ?> ctx) {
        super(ctx);
        this.path = (SchemaPath)ctx.getSchemaPath().get();
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (!(effectiveStatement instanceof UnknownSchemaNode)) continue;
            listBuilder.add((Object)((UnknownSchemaNode)effectiveStatement));
        }
        this.unknownNodes = listBuilder.build();
    }

    public final QName getQName() {
        return this.path.getLastComponent();
    }

    public final SchemaPath getPath() {
        return this.path;
    }

    public final List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }
}

