/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedDataNodeContainer;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public abstract class AbstractEffectiveSimpleDataNodeContainer<D extends DeclaredStatement<QName>>
extends AbstractEffectiveDocumentedDataNodeContainer<QName, D>
implements AugmentationTarget,
DataSchemaNode {
    private final ImmutableSet<AugmentationSchemaNode> augmentations;
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownNodes;
    private final RevisionAwareXPath whenCondition;
    private final @NonNull SchemaPath path;
    private final boolean configuration;
    private final boolean addedByUses;
    private boolean augmenting;

    protected AbstractEffectiveSimpleDataNodeContainer(StmtContext<QName, D, ?> ctx) {
        super(ctx);
        this.path = (SchemaPath)ctx.getSchemaPath().get();
        this.configuration = ctx.isConfiguration();
        this.whenCondition = this.findFirstEffectiveSubstatementArgument(WhenEffectiveStatement.class).orElse(null);
        ArrayList<UnknownSchemaNode> unknownNodesInit = new ArrayList<UnknownSchemaNode>();
        LinkedHashSet<AugmentationSchemaNode> augmentationsInit = new LinkedHashSet<AugmentationSchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (effectiveStatement instanceof UnknownSchemaNode) {
                unknownNodesInit.add((UnknownSchemaNode)effectiveStatement);
            }
            if (!(effectiveStatement instanceof AugmentationSchemaNode)) continue;
            augmentationsInit.add((AugmentationSchemaNode)effectiveStatement);
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
        this.augmentations = ImmutableSet.copyOf(augmentationsInit);
        CopyHistory copyTypesFromOriginal = ctx.getCopyHistory();
        if (copyTypesFromOriginal.contains(CopyType.ADDED_BY_USES_AUGMENTATION)) {
            this.augmenting = true;
            this.addedByUses = true;
        } else {
            this.augmenting = copyTypesFromOriginal.contains(CopyType.ADDED_BY_AUGMENTATION);
            this.addedByUses = copyTypesFromOriginal.contains(CopyType.ADDED_BY_USES);
        }
    }

    public QName getQName() {
        return this.path.getLastComponent();
    }

    public SchemaPath getPath() {
        return this.path;
    }

    @Deprecated
    public boolean isAugmenting() {
        return this.augmenting;
    }

    @Deprecated
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public boolean isConfiguration() {
        return this.configuration;
    }

    public Set<AugmentationSchemaNode> getAvailableAugmentations() {
        return this.augmentations;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public final Optional<RevisionAwareXPath> getWhenCondition() {
        return Optional.ofNullable(this.whenCondition);
    }

    @Deprecated
    public final void resetAugmenting() {
        this.augmenting = false;
    }
}

