/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@Beta
public abstract class AbstractSchemaEffectiveDocumentedNode<A, D extends DeclaredStatement<A>>
extends AbstractEffectiveDocumentedNode<A, D> {
    private final ImmutableMap<QName, DataTreeEffectiveStatement<?>> dataTreeNamespace;
    private final ImmutableMap<QName, SchemaTreeEffectiveStatement<?>> schemaTreeNamespace;

    protected AbstractSchemaEffectiveDocumentedNode(StmtContext<A, D, ?> ctx) {
        super(ctx);
        if (this instanceof SchemaTreeAwareEffectiveStatement) {
            StatementSourceReference ref = ctx.getStatementSourceReference();
            LinkedHashMap schemaChildren = new LinkedHashMap();
            this.streamEffectiveSubstatements(SchemaTreeEffectiveStatement.class).forEach(child -> AbstractSchemaEffectiveDocumentedNode.putChild(schemaChildren, child, ref, "schema"));
            this.schemaTreeNamespace = ImmutableMap.copyOf(schemaChildren);
            if (this instanceof DataTreeAwareEffectiveStatement && !this.schemaTreeNamespace.isEmpty()) {
                LinkedHashMap dataChildren = new LinkedHashMap();
                boolean sameAsSchema = true;
                for (SchemaTreeEffectiveStatement child2 : this.schemaTreeNamespace.values()) {
                    if (child2 instanceof DataTreeEffectiveStatement) {
                        AbstractSchemaEffectiveDocumentedNode.putChild(dataChildren, (DataTreeEffectiveStatement)child2, ref, "data");
                        continue;
                    }
                    sameAsSchema = false;
                    AbstractSchemaEffectiveDocumentedNode.putChoiceDataChildren(dataChildren, ref, child2);
                }
                this.dataTreeNamespace = sameAsSchema ? this.schemaTreeNamespace : ImmutableMap.copyOf(dataChildren);
            } else {
                this.dataTreeNamespace = ImmutableMap.of();
            }
        } else {
            this.dataTreeNamespace = ImmutableMap.of();
            this.schemaTreeNamespace = ImmutableMap.of();
        }
    }

    @Override
    protected <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(Class<N> namespace) {
        if (this instanceof SchemaTreeAwareEffectiveStatement && SchemaTreeAwareEffectiveStatement.Namespace.class.equals(namespace)) {
            return Optional.of(this.schemaTreeNamespace);
        }
        if (this instanceof DataTreeAwareEffectiveStatement && DataTreeAwareEffectiveStatement.Namespace.class.equals(namespace)) {
            return Optional.of(this.dataTreeNamespace);
        }
        return super.getNamespaceContents(namespace);
    }

    private static <T extends SchemaTreeEffectiveStatement<?>> void putChild(Map<QName, T> map, T child, StatementSourceReference ref, String tree) {
        QName id = child.getIdentifier();
        SchemaTreeEffectiveStatement prev = (SchemaTreeEffectiveStatement)map.putIfAbsent(id, child);
        SourceException.throwIf((prev != null ? 1 : 0) != 0, (StatementSourceReference)ref, (String)"Cannot add %s tree child with name %s, a conflicting child already exists", (Object[])new Object[]{tree, id});
    }

    private static void putChoiceDataChildren(Map<QName, DataTreeEffectiveStatement<?>> map, StatementSourceReference ref, SchemaTreeEffectiveStatement<?> child) {
        if (child instanceof ChoiceEffectiveStatement) {
            child.streamEffectiveSubstatements(CaseEffectiveStatement.class).forEach(caseStmt -> caseStmt.streamEffectiveSubstatements(SchemaTreeEffectiveStatement.class).forEach(stmt -> {
                if (stmt instanceof DataTreeEffectiveStatement) {
                    AbstractSchemaEffectiveDocumentedNode.putChild(map, (DataTreeEffectiveStatement)stmt, ref, "data");
                } else {
                    AbstractSchemaEffectiveDocumentedNode.putChoiceDataChildren(map, ref, stmt);
                }
            }));
        }
    }
}

