/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

public abstract class EffectiveStatementBase<A, D extends DeclaredStatement<A>>
implements EffectiveStatement<A, D> {
    private final @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> substatements;

    protected EffectiveStatementBase(StmtContext<A, D, ?> ctx) {
        Collection effectiveSubstatements = ctx.effectiveSubstatements();
        ArrayList<StmtContext> substatementsInit = new ArrayList<StmtContext>();
        Collection supportedDeclaredSubStmts = Collections2.filter((Collection)ctx.declaredSubstatements(), StmtContext::isSupportedByFeatures);
        for (StmtContext declaredSubstatement : supportedDeclaredSubStmts) {
            if (YangStmtMapping.USES == declaredSubstatement.getPublicDefinition()) {
                substatementsInit.add(declaredSubstatement);
                substatementsInit.addAll(declaredSubstatement.getEffectOfStatement());
                ((StatementContextBase)ctx).removeStatementsFromEffectiveSubstatements(declaredSubstatement.getEffectOfStatement());
                continue;
            }
            substatementsInit.add(declaredSubstatement);
        }
        substatementsInit.addAll(effectiveSubstatements);
        this.substatements = ImmutableList.copyOf(this.initSubstatements(substatementsInit));
    }

    protected Collection<? extends EffectiveStatement<?, ?>> initSubstatements(Collection<? extends StmtContext<?, ?, ?>> substatementsInit) {
        return Collections2.transform((Collection)Collections2.filter(substatementsInit, StmtContext::isSupportedToBuildEffective), StmtContext::buildEffective);
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> V get(Class<N> namespace, K identifier) {
        return this.findAll(namespace).get(Objects.requireNonNull(identifier));
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAll(Class<N> namespace) {
        return this.getNamespaceContents(Objects.requireNonNull(namespace)).orElse(null);
    }

    @Beta
    protected <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(@NonNull Class<N> namespace) {
        return Optional.empty();
    }

    public final Collection<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return this.substatements;
    }

    @Deprecated
    public final <S extends EffectiveStatement<?, ?>> S firstEffective(Class<S> type) {
        return (S)((EffectiveStatement)this.findFirstEffectiveSubstatement(type).orElse(null));
    }

    protected final <S extends SchemaNode> S firstSchemaNode(Class<S> type) {
        return (S)((SchemaNode)this.substatements.stream().filter(type::isInstance).findFirst().map(type::cast).orElse(null));
    }

    public final <T> Collection<T> allSubstatementsOfType(Class<T> type) {
        return (Collection)Collection.class.cast(Collections2.filter(this.substatements, type::isInstance));
    }

    protected final <T> @Nullable T firstSubstatementOfType(Class<T> type) {
        return this.substatements.stream().filter(type::isInstance).findFirst().map(type::cast).orElse(null);
    }

    protected final <R> R firstSubstatementOfType(Class<?> type, Class<R> returnType) {
        return this.substatements.stream().filter(((Predicate<Object>)type::isInstance).and(returnType::isInstance)).findFirst().map(returnType::cast).orElse(null);
    }

    protected final EffectiveStatement<?, ?> firstEffectiveSubstatementOfType(Class<?> type) {
        return this.substatements.stream().filter(type::isInstance).findFirst().orElse(null);
    }
}

