/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractSchemaEffectiveDocumentedNode;
import org.opendaylight.yangtools.yang.parser.spi.ExtensionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public abstract class UnknownEffectiveStatementBase<A, D extends UnknownStatement<A>>
extends AbstractSchemaEffectiveDocumentedNode<A, D>
implements UnknownSchemaNode {
    private final boolean addedByUses;
    private final boolean addedByAugmentation;
    private final ExtensionDefinition extension;
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownNodes;
    private final QName nodeType;
    private final String nodeParameter;

    protected UnknownEffectiveStatementBase(StmtContext<A, D, ?> ctx) {
        super(ctx);
        StmtContext extensionInit = (StmtContext)ctx.getFromNamespace(ExtensionNamespace.class, (Object)ctx.getPublicDefinition().getStatementName());
        if (extensionInit == null) {
            this.extension = null;
            this.nodeType = ctx.getPublicDefinition().getStatementName();
        } else {
            EffectiveStatement effective = extensionInit.buildEffective();
            Preconditions.checkState((boolean)(effective instanceof ExtensionDefinition), (String)"Statement %s is not an ExtensionDefinition", (Object)effective);
            this.extension = (ExtensionDefinition)extensionInit.buildEffective();
            this.nodeType = null;
        }
        CopyHistory copyTypesFromOriginal = ctx.getCopyHistory();
        if (copyTypesFromOriginal.contains(CopyType.ADDED_BY_USES_AUGMENTATION)) {
            this.addedByAugmentation = true;
            this.addedByUses = true;
        } else {
            this.addedByAugmentation = copyTypesFromOriginal.contains(CopyType.ADDED_BY_AUGMENTATION);
            this.addedByUses = copyTypesFromOriginal.contains(CopyType.ADDED_BY_USES);
        }
        this.nodeParameter = ctx.rawStatementArgument() == null ? "" : ctx.rawStatementArgument();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (!(effectiveStatement instanceof UnknownSchemaNode)) continue;
            builder.add((Object)((UnknownSchemaNode)effectiveStatement));
        }
        this.unknownNodes = builder.build();
    }

    @Deprecated
    public boolean isAddedByAugmentation() {
        return this.addedByAugmentation;
    }

    public QName getNodeType() {
        return this.extension == null ? this.nodeType : this.extension.getQName();
    }

    public String getNodeParameter() {
        return this.nodeParameter;
    }

    @Deprecated
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public ExtensionDefinition getExtensionDefinition() {
        return this.extension;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public String toString() {
        QName type = this.getNodeType();
        return String.valueOf(type.getNamespace()) + ":" + type.getLocalName() + " " + this.nodeParameter;
    }
}

