/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anydata;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDataSchemaNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

@Beta
final class AnydataEffectiveStatementImpl
extends AbstractEffectiveDataSchemaNode<AnydataStatement>
implements AnydataEffectiveStatement,
AnyDataSchemaNode,
DerivableSchemaNode {
    private final ImmutableSet<MustDefinition> mustConstraints;
    private final AnyDataSchemaNode original;
    private final ContainerSchemaNode schema;
    private final boolean mandatory;

    AnydataEffectiveStatementImpl(StmtContext<QName, AnydataStatement, EffectiveStatement<QName, AnydataStatement>> ctx) {
        super(ctx);
        this.original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        this.mandatory = this.findFirstEffectiveSubstatementArgument(MandatoryEffectiveStatement.class).orElse(Boolean.FALSE);
        this.mustConstraints = ImmutableSet.copyOf(this.allSubstatementsOfType(MustDefinition.class));
        this.schema = null;
    }

    public Optional<AnyDataSchemaNode> getOriginal() {
        return Optional.ofNullable(this.original);
    }

    public Optional<ContainerSchemaNode> getDataSchema() {
        return Optional.ofNullable(this.schema);
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public Collection<MustDefinition> getMustConstraints() {
        return this.mustConstraints;
    }

    public int hashCode() {
        return Objects.hash(this.getQName(), this.getPath());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnydataEffectiveStatementImpl other = (AnydataEffectiveStatementImpl)obj;
        return Objects.equals(this.getQName(), other.getQName()) && Objects.equals(this.getPath(), other.getPath());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("qname", (Object)this.getQName()).add("path", (Object)this.getPath()).toString();
    }
}

