/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anyxml;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDataSchemaNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public class AnyxmlEffectiveStatementImpl
extends AbstractEffectiveDataSchemaNode<AnyxmlStatement>
implements AnyxmlEffectiveStatement,
AnyXmlSchemaNode,
DerivableSchemaNode {
    private final ImmutableSet<MustDefinition> mustConstraints;
    private final AnyXmlSchemaNode original;
    private final boolean mandatory;

    AnyxmlEffectiveStatementImpl(StmtContext<QName, AnyxmlStatement, AnyxmlEffectiveStatement> ctx) {
        super(ctx);
        this.original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        this.mandatory = this.findFirstEffectiveSubstatementArgument(MandatoryEffectiveStatement.class).orElse(Boolean.FALSE);
        this.mustConstraints = ImmutableSet.copyOf(this.allSubstatementsOfType(MustDefinition.class));
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public Collection<MustDefinition> getMustConstraints() {
        return this.mustConstraints;
    }

    public Optional<AnyXmlSchemaNode> getOriginal() {
        return Optional.ofNullable(this.original);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getQName());
        result = 31 * result + Objects.hashCode(this.getPath());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyxmlEffectiveStatementImpl other = (AnyxmlEffectiveStatementImpl)obj;
        return Objects.equals(this.getQName(), other.getQName()) && Objects.equals(this.getPath(), other.getPath());
    }

    public String toString() {
        return AnyxmlEffectiveStatementImpl.class.getSimpleName() + "[qname=" + this.getQName() + ", path=" + this.getPath() + "]";
    }
}

