/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataDefinitionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment.AugmentEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment.AugmentStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.AugmentToChoiceNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StmtOrderingNamespace;
import org.opendaylight.yangtools.yang.parser.spi.validation.ValidationBundlesNamespace;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAugmentStatementSupport
extends AbstractStatementSupport<SchemaNodeIdentifier, AugmentStatement, EffectiveStatement<SchemaNodeIdentifier, AugmentStatement>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAugmentStatementSupport.class);
    private static final Pattern PATH_REL_PATTERN1 = Pattern.compile("\\.\\.?\\s*/(.+)");
    private static final Pattern PATH_REL_PATTERN2 = Pattern.compile("//.*");
    private static final ImmutableSet<YangStmtMapping> NOCOPY_DEF_SET = ImmutableSet.of((Object)YangStmtMapping.USES, (Object)YangStmtMapping.WHEN, (Object)YangStmtMapping.DESCRIPTION, (Object)YangStmtMapping.REFERENCE, (Object)YangStmtMapping.STATUS);
    private static final ImmutableSet<YangStmtMapping> REUSED_DEF_SET = ImmutableSet.of((Object)YangStmtMapping.TYPEDEF);

    AbstractAugmentStatementSupport() {
        super((StatementDefinition)YangStmtMapping.AUGMENT);
    }

    public final SchemaNodeIdentifier parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        SourceException.throwIf((PATH_REL_PATTERN1.matcher(value).matches() || PATH_REL_PATTERN2.matcher(value).matches() ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Augment argument '%s' is not valid, it can be only absolute path; or descendant if used in uses", (Object[])new Object[]{value});
        return ArgumentUtils.nodeIdentifierFromPath(ctx, value);
    }

    public final AugmentStatement createDeclared(StmtContext<SchemaNodeIdentifier, AugmentStatement, ?> ctx) {
        return new AugmentStatementImpl(ctx);
    }

    public final EffectiveStatement<SchemaNodeIdentifier, AugmentStatement> createEffective(StmtContext<SchemaNodeIdentifier, AugmentStatement, EffectiveStatement<SchemaNodeIdentifier, AugmentStatement>> ctx) {
        return new AugmentEffectiveStatementImpl(ctx);
    }

    public final void onFullDefinitionDeclared(final StmtContext.Mutable<SchemaNodeIdentifier, AugmentStatement, EffectiveStatement<SchemaNodeIdentifier, AugmentStatement>> augmentNode) {
        if (!augmentNode.isSupportedByFeatures()) {
            return;
        }
        super.onFullDefinitionDeclared(augmentNode);
        if (StmtContextUtils.isInExtensionBody(augmentNode)) {
            return;
        }
        ModelActionBuilder augmentAction = augmentNode.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        ModelActionBuilder.Prerequisite sourceCtxPrereq = augmentAction.requiresCtx(augmentNode, ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite target = augmentAction.mutatesEffectiveCtxPath(AbstractAugmentStatementSupport.getSearchRoot(augmentNode), ChildSchemaNodeNamespace.class, ((SchemaNodeIdentifier)augmentNode.coerceStatementArgument()).getPathFromRoot());
        augmentAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StatementContextBase augmentTargetCtx = (StatementContextBase)target.resolve(ctx);
                if (!AbstractAugmentStatementSupport.isSupportedAugmentTarget(augmentTargetCtx) || StmtContextUtils.isInExtensionBody((StmtContext)augmentTargetCtx)) {
                    augmentNode.setIsSupportedToBuildEffective(false);
                    return;
                }
                if (augmentTargetCtx.getPublicDefinition() == YangStmtMapping.CHOICE) {
                    augmentNode.addToNs(AugmentToChoiceNamespace.class, (Object)augmentNode, (Object)Boolean.TRUE);
                }
                StatementContextBase augmentSourceCtx = (StatementContextBase)augmentNode;
                try {
                    AbstractAugmentStatementSupport.copyFromSourceToTarget(augmentSourceCtx, augmentTargetCtx);
                    augmentTargetCtx.addEffectiveSubstatement((StmtContext.Mutable)augmentSourceCtx);
                    this.updateAugmentOrder(augmentSourceCtx);
                }
                catch (SourceException e) {
                    LOG.warn("Failed to add augmentation {} defined at {}", new Object[]{augmentTargetCtx.getStatementSourceReference(), augmentSourceCtx.getStatementSourceReference(), e});
                }
            }

            private void updateAugmentOrder(StatementContextBase<?, ?, ?> augmentSourceCtx) {
                Integer currentOrder = (Integer)augmentSourceCtx.getFromNamespace(StmtOrderingNamespace.class, (Object)YangStmtMapping.AUGMENT);
                if (currentOrder == null) {
                    currentOrder = 1;
                } else {
                    Integer n = currentOrder;
                    Integer n2 = currentOrder = Integer.valueOf(currentOrder + 1);
                }
                augmentSourceCtx.addToNs(StmtOrderingNamespace.class, (Object)YangStmtMapping.AUGMENT, (Object)currentOrder);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                if (YangStmtMapping.USES == augmentNode.coerceParentContext().getPublicDefinition()) {
                    SchemaNodeIdentifier augmentArg = (SchemaNodeIdentifier)augmentNode.coerceStatementArgument();
                    Optional<StmtContext<?, ?, ?>> targetNode = ChildSchemaNodeNamespace.findNode(AbstractAugmentStatementSupport.getSearchRoot((StmtContext)augmentNode), augmentArg);
                    if (targetNode.isPresent() && StmtContextUtils.isUnknownStatement(targetNode.get())) {
                        augmentNode.setIsSupportedToBuildEffective(false);
                        LOG.warn("Uses-augment to unknown node {}. Augmentation has not been performed. At line: {}", (Object)augmentArg, (Object)augmentNode.getStatementSourceReference());
                        return;
                    }
                }
                throw new InferenceException(augmentNode.getStatementSourceReference(), "Augment target '%s' not found", new Object[]{augmentNode.getStatementArgument()});
            }
        });
    }

    private static StmtContext<?, ?, ?> getSearchRoot(StmtContext<?, ?, ?> augmentContext) {
        StmtContext parent = augmentContext.coerceParentContext();
        if (YangStmtMapping.USES == parent.getPublicDefinition()) {
            return parent.getParentContext();
        }
        return parent;
    }

    static void copyFromSourceToTarget(StatementContextBase<?, ?, ?> sourceCtx, StatementContextBase<?, ?, ?> targetCtx) {
        CopyType typeOfCopy = UsesStatement.class.equals((Object)sourceCtx.coerceParentContext().getPublicDefinition().getDeclaredRepresentationClass()) ? CopyType.ADDED_BY_USES_AUGMENTATION : CopyType.ADDED_BY_AUGMENTATION;
        boolean skipCheckOfMandatoryNodes = YangVersion.VERSION_1_1.equals((Object)sourceCtx.getRootVersion()) && AbstractAugmentStatementSupport.isConditionalAugmentStmt(sourceCtx);
        Collection declared = sourceCtx.mutableDeclaredSubstatements();
        Collection effective = sourceCtx.mutableEffectiveSubstatements();
        ArrayList buffer = new ArrayList(declared.size() + effective.size());
        for (StmtContext.Mutable originalStmtCtx : declared) {
            if (!originalStmtCtx.isSupportedByFeatures()) continue;
            AbstractAugmentStatementSupport.copyStatement(originalStmtCtx, targetCtx, typeOfCopy, buffer, skipCheckOfMandatoryNodes);
        }
        for (StmtContext.Mutable originalStmtCtx : effective) {
            AbstractAugmentStatementSupport.copyStatement(originalStmtCtx, targetCtx, typeOfCopy, buffer, skipCheckOfMandatoryNodes);
        }
        targetCtx.addEffectiveSubstatements(buffer);
    }

    private static boolean isConditionalAugmentStmt(StmtContext<?, ?, ?> ctx) {
        return ctx.getPublicDefinition() == YangStmtMapping.AUGMENT && StmtContextUtils.findFirstSubstatement(ctx, WhenStatement.class) != null;
    }

    private static void copyStatement(StmtContext.Mutable<?, ?, ?> original, StatementContextBase<?, ?, ?> target, CopyType typeOfCopy, Collection<StmtContext.Mutable<?, ?, ?>> buffer, boolean skipCheckOfMandatoryNodes) {
        if (AbstractAugmentStatementSupport.needToCopyByAugment(original)) {
            AbstractAugmentStatementSupport.validateNodeCanBeCopiedByAugment(original, target, typeOfCopy, skipCheckOfMandatoryNodes);
            buffer.add(target.childCopyOf(original, typeOfCopy));
        } else if (AbstractAugmentStatementSupport.isReusedByAugment(original)) {
            buffer.add(original);
        }
    }

    private static void validateNodeCanBeCopiedByAugment(StmtContext<?, ?, ?> sourceCtx, StatementContextBase<?, ?, ?> targetCtx, CopyType typeOfCopy, boolean skipCheckOfMandatoryNodes) {
        if (WhenStatement.class.equals((Object)sourceCtx.getPublicDefinition().getDeclaredRepresentationClass())) {
            return;
        }
        if (!skipCheckOfMandatoryNodes && typeOfCopy == CopyType.ADDED_BY_AUGMENTATION && AbstractAugmentStatementSupport.reguiredCheckOfMandatoryNodes(sourceCtx, targetCtx)) {
            AbstractAugmentStatementSupport.checkForMandatoryNodes(sourceCtx);
        }
        if (DataDefinitionStatement.class.isAssignableFrom(sourceCtx.getPublicDefinition().getDeclaredRepresentationClass())) {
            for (StmtContext subStatement : targetCtx.allSubstatements()) {
                if (!DataDefinitionStatement.class.isAssignableFrom(subStatement.getPublicDefinition().getDeclaredRepresentationClass())) continue;
                InferenceException.throwIf((boolean)Objects.equals(sourceCtx.getStatementArgument(), subStatement.getStatementArgument()), (StatementSourceReference)sourceCtx.getStatementSourceReference(), (String)"An augment cannot add node named '%s' because this name is already used in target", (Object[])new Object[]{sourceCtx.rawStatementArgument()});
            }
        }
    }

    private static void checkForMandatoryNodes(StmtContext<?, ?, ?> sourceCtx) {
        if (StmtContextUtils.isNonPresenceContainer(sourceCtx)) {
            sourceCtx.allSubstatementsStream().forEach(AbstractAugmentStatementSupport::checkForMandatoryNodes);
        }
        InferenceException.throwIf((boolean)StmtContextUtils.isMandatoryNode(sourceCtx), (StatementSourceReference)sourceCtx.getStatementSourceReference(), (String)"An augment cannot add node '%s' because it is mandatory and in module different than target", (Object[])new Object[]{sourceCtx.rawStatementArgument()});
    }

    private static boolean reguiredCheckOfMandatoryNodes(StmtContext<?, ?, ?> sourceCtx, StmtContext.Mutable<?, ?, ?> targetCtx) {
        if (!(sourceCtx.getStatementArgument() instanceof QName)) {
            return false;
        }
        QName sourceStmtQName = (QName)sourceCtx.getStatementArgument();
        StmtContext.Mutable root = targetCtx.getRoot();
        do {
            Verify.verify((boolean)(targetCtx.getStatementArgument() instanceof QName), (String)"Argument of augment target statement must be QName.", (Object[])new Object[0]);
            QName targetStmtQName = (QName)targetCtx.getStatementArgument();
            if (!targetStmtQName.getModule().equals((Object)sourceStmtQName.getModule())) {
                return true;
            }
            if (!StmtContextUtils.isPresenceContainer(targetCtx) && !StmtContextUtils.isNotMandatoryNodeOfType(targetCtx, (StatementDefinition)YangStmtMapping.CHOICE) && !StmtContextUtils.isNotMandatoryNodeOfType(targetCtx, (StatementDefinition)YangStmtMapping.LIST)) continue;
            return false;
        } while ((targetCtx = targetCtx.getParentContext()) != root);
        return false;
    }

    private static boolean needToCopyByAugment(StmtContext<?, ?, ?> stmtContext) {
        return !NOCOPY_DEF_SET.contains((Object)stmtContext.getPublicDefinition());
    }

    private static boolean isReusedByAugment(StmtContext<?, ?, ?> stmtContext) {
        return REUSED_DEF_SET.contains((Object)stmtContext.getPublicDefinition());
    }

    static boolean isSupportedAugmentTarget(StmtContext<?, ?, ?> substatementCtx) {
        Collection allowedAugmentTargets = (Collection)substatementCtx.getFromNamespace(ValidationBundlesNamespace.class, (Object)ValidationBundlesNamespace.ValidationBundleType.SUPPORTED_AUGMENT_TARGETS);
        return allowedAugmentTargets == null || allowedAugmentTargets.isEmpty() || allowedAugmentTargets.contains(substatementCtx.getPublicDefinition());
    }
}

