/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.base;

import java.util.ArrayList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.base.BaseEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.base.BaseStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.IdentityNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.DerivedIdentitiesNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class BaseStatementSupport
extends AbstractQNameStatementSupport<BaseStatement, EffectiveStatement<QName, BaseStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.BASE).build();
    private static final BaseStatementSupport INSTANCE = new BaseStatementSupport();

    private BaseStatementSupport() {
        super((StatementDefinition)YangStmtMapping.BASE);
    }

    public static BaseStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseNodeIdentifier(ctx, (String)value);
    }

    public BaseStatement createDeclared(StmtContext<QName, BaseStatement, ?> ctx) {
        return new BaseStatementImpl(ctx);
    }

    public EffectiveStatement<QName, BaseStatement> createEffective(StmtContext<QName, BaseStatement, EffectiveStatement<QName, BaseStatement>> ctx) {
        return new BaseEffectiveStatementImpl(ctx);
    }

    public void onStatementDefinitionDeclared(final StmtContext.Mutable<QName, BaseStatement, EffectiveStatement<QName, BaseStatement>> baseStmtCtx) {
        final StmtContext.Mutable baseParentCtx = baseStmtCtx.getParentContext();
        if (StmtContextUtils.producesDeclared((StmtContext)baseParentCtx, IdentityStatement.class)) {
            final QName baseIdentityQName = (QName)baseStmtCtx.coerceStatementArgument();
            ModelActionBuilder baseIdentityAction = baseStmtCtx.newInferenceAction(ModelProcessingPhase.STATEMENT_DEFINITION);
            ModelActionBuilder.Prerequisite requiresPrereq = baseIdentityAction.requiresCtx(baseStmtCtx, IdentityNamespace.class, (Object)baseIdentityQName, ModelProcessingPhase.STATEMENT_DEFINITION);
            ModelActionBuilder.Prerequisite mutatesPrereq = baseIdentityAction.mutatesCtx(baseParentCtx, ModelProcessingPhase.STATEMENT_DEFINITION);
            baseIdentityAction.apply(new ModelActionBuilder.InferenceAction(){

                public void apply(ModelActionBuilder.InferenceContext ctx) {
                    ArrayList<StmtContext.Mutable> derivedIdentities = (ArrayList<StmtContext.Mutable>)baseStmtCtx.getFromNamespace(DerivedIdentitiesNamespace.class, (Object)baseIdentityQName);
                    if (derivedIdentities == null) {
                        derivedIdentities = new ArrayList<StmtContext.Mutable>(1);
                        baseStmtCtx.addToNs(DerivedIdentitiesNamespace.class, (Object)baseIdentityQName, derivedIdentities);
                    }
                    derivedIdentities.add(baseParentCtx);
                }

                public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                    throw new InferenceException(baseStmtCtx.getStatementSourceReference(), "Unable to resolve identity %s and base identity %s", new Object[]{baseParentCtx.getStatementArgument(), baseStmtCtx.getStatementArgument()});
                }
            });
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

