/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.bit;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BitEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BitStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PositionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public final class BitEffectiveStatementImpl
extends AbstractEffectiveDocumentedNode<QName, BitStatement>
implements BitEffectiveStatement {
    private final QName qname;
    private final SchemaPath schemaPath;
    private final Long declaredPosition;
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownSchemaNodes;

    BitEffectiveStatementImpl(StmtContext<QName, BitStatement, ?> ctx) {
        super(ctx);
        this.qname = (QName)ctx.getStatementArgument();
        this.schemaPath = (SchemaPath)ctx.getSchemaPath().get();
        ArrayList<UnknownSchemaNode> unknownSchemaNodesInit = new ArrayList<UnknownSchemaNode>();
        Long declaredPositionInit = null;
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (effectiveStatement instanceof PositionEffectiveStatement) {
                declaredPositionInit = (Long)((PositionEffectiveStatement)effectiveStatement).argument();
            }
            if (!(effectiveStatement instanceof UnknownSchemaNode)) continue;
            unknownSchemaNodesInit.add((UnknownSchemaNode)effectiveStatement);
        }
        this.declaredPosition = declaredPositionInit;
        this.unknownSchemaNodes = ImmutableList.copyOf(unknownSchemaNodesInit);
    }

    public Long getDeclaredPosition() {
        return this.declaredPosition;
    }

    public String getName() {
        return this.qname.getLocalName();
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.schemaPath;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownSchemaNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.qname.hashCode();
        result = 31 * result + this.schemaPath.hashCode();
        result = 31 * result + Objects.hashCode(this.declaredPosition);
        result = 31 * result + Objects.hashCode(this.unknownSchemaNodes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitsTypeDefinition.Bit other = (BitsTypeDefinition.Bit)obj;
        return Objects.equals(this.qname, other.getQName()) && Objects.equals(this.schemaPath, other.getPath());
    }

    public String toString() {
        return BitEffectiveStatementImpl.class.getSimpleName() + "[name=" + this.qname.getLocalName() + ", position=" + this.declaredPosition + "]";
    }
}

