/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.choice;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.reactor.YangValidationBundles;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDataSchemaNode;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anyxml.AnyxmlEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.choice.ImplicitCaseSchemaNode;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.container.ContainerEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf.LeafEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf_list.LeafListEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.list.ListEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class ChoiceEffectiveStatementImpl
extends AbstractEffectiveDataSchemaNode<ChoiceStatement>
implements ChoiceEffectiveStatement,
ChoiceSchemaNode,
DerivableSchemaNode {
    private final ImmutableSet<AugmentationSchemaNode> augmentations;
    private final ImmutableSortedMap<QName, CaseSchemaNode> cases;
    private final CaseSchemaNode defaultCase;
    private final ChoiceSchemaNode original;
    private final boolean mandatory;

    ChoiceEffectiveStatementImpl(StmtContext<QName, ChoiceStatement, EffectiveStatement<QName, ChoiceStatement>> ctx) {
        super(ctx);
        this.original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        LinkedHashSet<AugmentationSchemaNode> augmentationsInit = new LinkedHashSet<AugmentationSchemaNode>();
        TreeMap<QName, CaseSchemaNode> casesInit = new TreeMap<QName, CaseSchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (effectiveStatement instanceof AugmentationSchemaNode) {
                AugmentationSchemaNode augmentationSchema = (AugmentationSchemaNode)effectiveStatement;
                augmentationsInit.add(augmentationSchema);
            }
            if (effectiveStatement instanceof CaseSchemaNode) {
                CaseSchemaNode choiceCaseNode = (CaseSchemaNode)effectiveStatement;
                casesInit.put(choiceCaseNode.getQName(), choiceCaseNode);
            }
            if (!YangValidationBundles.SUPPORTED_CASE_SHORTHANDS.contains(effectiveStatement.statementDefinition())) continue;
            DataSchemaNode dataSchemaNode = (DataSchemaNode)effectiveStatement;
            ImplicitCaseSchemaNode shorthandCase = new ImplicitCaseSchemaNode(dataSchemaNode);
            casesInit.put(shorthandCase.getQName(), shorthandCase);
            if (!dataSchemaNode.isAugmenting() || this.isAugmenting()) continue;
            ChoiceEffectiveStatementImpl.resetAugmenting(dataSchemaNode);
        }
        this.augmentations = ImmutableSet.copyOf(augmentationsInit);
        this.cases = ImmutableSortedMap.copyOfSorted(casesInit);
        Optional defaultArg = this.findFirstEffectiveSubstatementArgument(DefaultEffectiveStatement.class);
        if (defaultArg.isPresent()) {
            QName qname;
            String arg = (String)defaultArg.get();
            try {
                qname = QName.create((QName)this.getQName(), (String)arg);
            }
            catch (IllegalArgumentException e) {
                throw new SourceException(ctx.getStatementSourceReference(), "Default statement has invalid name '%s'", new Object[]{arg, e});
            }
            this.defaultCase = (CaseSchemaNode)InferenceException.throwIfNull((Object)this.cases.get((Object)qname), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Default statement refers to missing case %s", (Object[])new Object[]{qname});
        } else {
            this.defaultCase = null;
        }
        this.mandatory = this.findFirstEffectiveSubstatementArgument(MandatoryEffectiveStatement.class).orElse(Boolean.FALSE);
    }

    private static void resetAugmenting(DataSchemaNode dataSchemaNode) {
        if (dataSchemaNode instanceof LeafEffectiveStatementImpl) {
            LeafEffectiveStatementImpl leaf = (LeafEffectiveStatementImpl)dataSchemaNode;
            leaf.resetAugmenting();
        } else if (dataSchemaNode instanceof ContainerEffectiveStatementImpl) {
            ContainerEffectiveStatementImpl container = (ContainerEffectiveStatementImpl)dataSchemaNode;
            container.resetAugmenting();
        } else if (dataSchemaNode instanceof LeafListEffectiveStatementImpl) {
            LeafListEffectiveStatementImpl leafList = (LeafListEffectiveStatementImpl)dataSchemaNode;
            leafList.resetAugmenting();
        } else if (dataSchemaNode instanceof ListEffectiveStatementImpl) {
            ListEffectiveStatementImpl list = (ListEffectiveStatementImpl)dataSchemaNode;
            list.resetAugmenting();
        } else if (dataSchemaNode instanceof AnyxmlEffectiveStatementImpl) {
            AnyxmlEffectiveStatementImpl anyXml = (AnyxmlEffectiveStatementImpl)dataSchemaNode;
            anyXml.resetAugmenting();
        }
    }

    public Optional<ChoiceSchemaNode> getOriginal() {
        return Optional.ofNullable(this.original);
    }

    public Set<AugmentationSchemaNode> getAvailableAugmentations() {
        return this.augmentations;
    }

    public SortedMap<QName, CaseSchemaNode> getCases() {
        return this.cases;
    }

    public Optional<CaseSchemaNode> getDefaultCase() {
        return Optional.ofNullable(this.defaultCase);
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getQName());
        result = 31 * result + Objects.hashCode(this.getPath());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChoiceEffectiveStatementImpl other = (ChoiceEffectiveStatementImpl)obj;
        return Objects.equals(this.getQName(), other.getQName()) && Objects.equals(this.getPath(), other.getPath());
    }

    public String toString() {
        return ChoiceEffectiveStatementImpl.class.getSimpleName() + "[qname=" + this.getQName() + "]";
    }
}

