/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.choice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public final class ImplicitCaseSchemaNode
implements CaseSchemaNode,
DerivableSchemaNode {
    private final @NonNull DataSchemaNode caseShorthandNode;
    private final @Nullable CaseSchemaNode original;
    private final @NonNull SchemaPath path;
    private final boolean augmenting;

    public ImplicitCaseSchemaNode(DataSchemaNode caseShorthandNode) {
        this.caseShorthandNode = Objects.requireNonNull(caseShorthandNode);
        this.path = Objects.requireNonNull(caseShorthandNode.getPath().getParent());
        this.original = ImplicitCaseSchemaNode.getOriginalIfPresent((SchemaNode)caseShorthandNode);
        this.augmenting = caseShorthandNode.isAugmenting();
    }

    @Deprecated
    public boolean isAugmenting() {
        return this.augmenting;
    }

    @Deprecated
    public boolean isAddedByUses() {
        return this.caseShorthandNode.isAddedByUses();
    }

    public boolean isConfiguration() {
        return this.caseShorthandNode.isConfiguration();
    }

    public QName getQName() {
        return this.caseShorthandNode.getQName();
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public Optional<String> getDescription() {
        return this.caseShorthandNode.getDescription();
    }

    public Optional<String> getReference() {
        return this.caseShorthandNode.getReference();
    }

    public Status getStatus() {
        return this.caseShorthandNode.getStatus();
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        return ImmutableSet.of();
    }

    public Collection<DataSchemaNode> getChildNodes() {
        return ImmutableList.of((Object)this.caseShorthandNode);
    }

    public Set<GroupingDefinition> getGroupings() {
        return ImmutableSet.of();
    }

    public Optional<DataSchemaNode> findDataChildByName(QName name) {
        return name.equals((Object)this.getQName()) ? Optional.of(this.caseShorthandNode) : Optional.empty();
    }

    public Set<UsesNode> getUses() {
        return ImmutableSet.of();
    }

    public Set<AugmentationSchemaNode> getAvailableAugmentations() {
        return ImmutableSet.of();
    }

    public Optional<? extends SchemaNode> getOriginal() {
        return Optional.ofNullable(this.original);
    }

    public Optional<RevisionAwareXPath> getWhenCondition() {
        return this.caseShorthandNode.getWhenCondition();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getQName());
        result = 31 * result + Objects.hashCode(this.path);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImplicitCaseSchemaNode other = (ImplicitCaseSchemaNode)obj;
        return Objects.equals(this.getQName(), other.getQName()) && Objects.equals(this.path, other.path);
    }

    public String toString() {
        return ImplicitCaseSchemaNode.class.getSimpleName() + "[qname=" + this.getQName() + "]";
    }

    private static CaseSchemaNode getOriginalIfPresent(SchemaNode caseShorthandNode) {
        Optional original;
        if (caseShorthandNode instanceof DerivableSchemaNode && (original = ((DerivableSchemaNode)caseShorthandNode).getOriginal()).isPresent()) {
            return new ImplicitCaseSchemaNode((DataSchemaNode)original.get());
        }
        return null;
    }
}

