/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.container;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PresenceEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveContainerSchemaNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public final class ContainerEffectiveStatementImpl
extends AbstractEffectiveContainerSchemaNode<ContainerStatement>
implements ContainerEffectiveStatement,
DerivableSchemaNode {
    private final @NonNull ImmutableSet<ActionDefinition> actions;
    private final @NonNull ImmutableSet<NotificationDefinition> notifications;
    private final @Nullable ContainerSchemaNode original;
    private final boolean presence;

    ContainerEffectiveStatementImpl(StmtContext<QName, ContainerStatement, EffectiveStatement<QName, ContainerStatement>> ctx) {
        super(ctx);
        this.original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        ImmutableSet.Builder actionsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder notificationsBuilder = ImmutableSet.builder();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (effectiveStatement instanceof ActionDefinition) {
                actionsBuilder.add((Object)((ActionDefinition)effectiveStatement));
            }
            if (!(effectiveStatement instanceof NotificationDefinition)) continue;
            notificationsBuilder.add((Object)((NotificationDefinition)effectiveStatement));
        }
        this.actions = actionsBuilder.build();
        this.notifications = notificationsBuilder.build();
        this.presence = this.findFirstEffectiveSubstatement(PresenceEffectiveStatement.class).isPresent();
    }

    public Optional<ContainerSchemaNode> getOriginal() {
        return Optional.ofNullable(this.original);
    }

    public Set<ActionDefinition> getActions() {
        return this.actions;
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.notifications;
    }

    public boolean isPresenceContainer() {
        return this.presence;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getQName());
        result = 31 * result + Objects.hashCode(this.getPath());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerEffectiveStatementImpl other = (ContainerEffectiveStatementImpl)obj;
        return Objects.equals(this.getQName(), other.getQName()) && Objects.equals(this.getPath(), other.getPath());
    }

    public String toString() {
        return "container " + this.getQName().getLocalName();
    }
}

