/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviation;

import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviationStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviation.DeviationEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviation.DeviationStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;

public final class DeviationStatementSupport
extends AbstractStatementSupport<SchemaNodeIdentifier, DeviationStatement, EffectiveStatement<SchemaNodeIdentifier, DeviationStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATION).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.DEVIATE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();
    private static final DeviationStatementSupport INSTANCE = new DeviationStatementSupport();

    private DeviationStatementSupport() {
        super((StatementDefinition)YangStmtMapping.DEVIATION);
    }

    public static DeviationStatementSupport getInstance() {
        return INSTANCE;
    }

    public SchemaNodeIdentifier parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return ArgumentUtils.nodeIdentifierFromPath(ctx, value);
    }

    public DeviationStatement createDeclared(StmtContext<SchemaNodeIdentifier, DeviationStatement, ?> ctx) {
        return new DeviationStatementImpl(ctx);
    }

    public EffectiveStatement<SchemaNodeIdentifier, DeviationStatement> createEffective(StmtContext<SchemaNodeIdentifier, DeviationStatement, EffectiveStatement<SchemaNodeIdentifier, DeviationStatement>> ctx) {
        return new DeviationEffectiveStatementImpl(ctx);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<SchemaNodeIdentifier, DeviationStatement, EffectiveStatement<SchemaNodeIdentifier, DeviationStatement>> ctx) {
        QNameModule targetModule;
        QNameModule currentModule = (QNameModule)ctx.getFromNamespace(ModuleCtxToModuleQName.class, (Object)ctx.getRoot());
        if (currentModule.equals((Object)(targetModule = ((SchemaNodeIdentifier)ctx.coerceStatementArgument()).getLastComponent().getModule()))) {
            throw new InferenceException(ctx.getStatementSourceReference(), "Deviation must not target the same module as the one it is defined in: %s", new Object[]{currentModule});
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

