/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.UnrecognizedEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnrecognizedStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;

final class UnrecognizedEffectiveStatementImpl
extends UnknownEffectiveStatementBase<String, UnrecognizedStatement>
implements UnrecognizedEffectiveStatement {
    private final QName maybeQNameArgument;
    private final @NonNull SchemaPath path;

    UnrecognizedEffectiveStatementImpl(StmtContext<String, UnrecognizedStatement, ?> ctx) {
        super(ctx);
        UnknownSchemaNode original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        if (original != null) {
            this.maybeQNameArgument = original.getQName();
        } else {
            QName maybeQNameArgumentInit = null;
            try {
                maybeQNameArgumentInit = StmtContextUtils.qnameFromArgument(ctx, (String)((String)this.argument()));
            }
            catch (IllegalArgumentException e) {
                maybeQNameArgumentInit = this.getNodeType();
            }
            this.maybeQNameArgument = maybeQNameArgumentInit;
        }
        this.path = ((SchemaPath)ctx.coerceParentContext().getSchemaPath().get()).createChild(this.maybeQNameArgument);
    }

    public QName getQName() {
        return this.maybeQNameArgument;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.maybeQNameArgument);
        result = 31 * result + Objects.hashCode(this.path);
        result = 31 * result + Objects.hashCode(this.getNodeType());
        result = 31 * result + Objects.hashCode(this.getNodeParameter());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnrecognizedEffectiveStatementImpl)) {
            return false;
        }
        UnrecognizedEffectiveStatementImpl other = (UnrecognizedEffectiveStatementImpl)obj;
        return Objects.equals(this.maybeQNameArgument, other.maybeQNameArgument) && Objects.equals(this.path, other.path) && Objects.equals(this.getNodeType(), other.getNodeType()) && Objects.equals(this.getNodeParameter(), other.getNodeParameter());
    }
}

