/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.fraction_digits;

import com.google.common.collect.Range;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.fraction_digits.FractionDigitsEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.fraction_digits.FractionDigitsStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class FractionDigitsStatementSupport
extends AbstractStatementSupport<Integer, FractionDigitsStatement, EffectiveStatement<Integer, FractionDigitsStatement>> {
    private static final Range<Integer> FRAC_DIGITS_ALLOWED = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(18));
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.FRACTION_DIGITS).build();
    private static final FractionDigitsStatementSupport INSTANCE = new FractionDigitsStatementSupport();

    private FractionDigitsStatementSupport() {
        super((StatementDefinition)YangStmtMapping.FRACTION_DIGITS);
    }

    public static FractionDigitsStatementSupport getInstance() {
        return INSTANCE;
    }

    public Integer parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        Integer fractionDigits;
        try {
            fractionDigits = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "%s is not valid fraction-digits integer argument", new Object[]{value});
        }
        SourceException.throwIf((!FRAC_DIGITS_ALLOWED.contains((Comparable)fractionDigits) ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"fraction-digits argument should be integer within %s", (Object[])new Object[]{FRAC_DIGITS_ALLOWED});
        return fractionDigits;
    }

    public FractionDigitsStatement createDeclared(StmtContext<Integer, FractionDigitsStatement, ?> ctx) {
        return new FractionDigitsStatementImpl(ctx);
    }

    public EffectiveStatement<Integer, FractionDigitsStatement> createEffective(StmtContext<Integer, FractionDigitsStatement, EffectiveStatement<Integer, FractionDigitsStatement>> ctx) {
        return new FractionDigitsEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

