/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.grouping;

import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.grouping.GroupingEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.grouping.GroupingStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.GroupingNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractGroupingStatementSupport
extends AbstractQNameStatementSupport<GroupingStatement, EffectiveStatement<QName, GroupingStatement>> {
    AbstractGroupingStatementSupport() {
        super((StatementDefinition)YangStmtMapping.GROUPING);
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public final GroupingStatement createDeclared(StmtContext<QName, GroupingStatement, ?> ctx) {
        StmtContext grandParent;
        StmtContext parent = ctx.getParentContext();
        if (parent != null && (grandParent = parent.getParentContext()) != null) {
            AbstractGroupingStatementSupport.checkConflict(grandParent, ctx);
        }
        return new GroupingStatementImpl(ctx);
    }

    public final EffectiveStatement<QName, GroupingStatement> createEffective(StmtContext<QName, GroupingStatement, EffectiveStatement<QName, GroupingStatement>> ctx) {
        return new GroupingEffectiveStatementImpl(ctx);
    }

    public final void onFullDefinitionDeclared(StmtContext.Mutable<QName, GroupingStatement, EffectiveStatement<QName, GroupingStatement>> stmt) {
        StmtContext.Mutable parent;
        super.onFullDefinitionDeclared(stmt);
        if (stmt != null && (parent = stmt.getParentContext()) != null) {
            AbstractGroupingStatementSupport.checkConflict(parent, stmt);
            parent.addContext(GroupingNamespace.class, stmt.coerceStatementArgument(), stmt);
        }
    }

    private static void checkConflict(StmtContext<?, ?, ?> parent, StmtContext<QName, ?, ?> stmt) {
        QName arg = (QName)stmt.coerceStatementArgument();
        StmtContext existing = (StmtContext)parent.getFromNamespace(GroupingNamespace.class, (Object)arg);
        SourceException.throwIf((existing != null ? 1 : 0) != 0, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Duplicate name for grouping %s", (Object[])new Object[]{arg});
    }
}

