/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.grouping;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedDataNodeContainer;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class GroupingEffectiveStatementImpl
extends AbstractEffectiveDocumentedDataNodeContainer<QName, GroupingStatement>
implements GroupingDefinition,
GroupingEffectiveStatement {
    private final @NonNull QName qname;
    private final @NonNull SchemaPath path;
    private final boolean addedByUses;
    private final @NonNull ImmutableSet<ActionDefinition> actions;
    private final @NonNull ImmutableSet<NotificationDefinition> notifications;
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownNodes;

    GroupingEffectiveStatementImpl(StmtContext<QName, GroupingStatement, EffectiveStatement<QName, GroupingStatement>> ctx) {
        super(ctx);
        this.qname = (QName)ctx.coerceStatementArgument();
        this.path = (SchemaPath)ctx.getSchemaPath().get();
        this.addedByUses = ctx.getCopyHistory().contains(CopyType.ADDED_BY_USES);
        ImmutableSet.Builder actionsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder notificationsBuilder = ImmutableSet.builder();
        ImmutableList.Builder b = ImmutableList.builder();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (effectiveStatement instanceof ActionDefinition) {
                actionsBuilder.add((Object)((ActionDefinition)effectiveStatement));
            }
            if (effectiveStatement instanceof NotificationDefinition) {
                notificationsBuilder.add((Object)((NotificationDefinition)effectiveStatement));
            }
            if (!(effectiveStatement instanceof UnknownSchemaNode)) continue;
            b.add((Object)((UnknownSchemaNode)effectiveStatement));
        }
        this.actions = actionsBuilder.build();
        this.notifications = notificationsBuilder.build();
        this.unknownNodes = b.build();
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public Set<ActionDefinition> getActions() {
        return this.actions;
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.notifications;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.qname);
        result = 31 * result + Objects.hashCode(this.path);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupingEffectiveStatementImpl other = (GroupingEffectiveStatementImpl)obj;
        return Objects.equals(this.qname, other.qname) && Objects.equals(this.path, other.path);
    }

    public String toString() {
        return GroupingEffectiveStatementImpl.class.getSimpleName() + "[qname=" + this.qname + "]";
    }
}

