/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.identity;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveSchemaNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.DerivedIdentitiesNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class IdentityEffectiveStatementImpl
extends AbstractEffectiveSchemaNode<IdentityStatement>
implements IdentityEffectiveStatement,
IdentitySchemaNode,
MutableStatement {
    private final ImmutableSet<IdentitySchemaNode> derivedIdentities;
    private @NonNull Set<IdentitySchemaNode> baseIdentities = new HashSet<IdentitySchemaNode>();
    private boolean sealed;

    IdentityEffectiveStatementImpl(StmtContext<QName, IdentityStatement, EffectiveStatement<QName, IdentityStatement>> ctx) {
        super(ctx);
        ((StmtContext.Mutable)ctx).addMutableStmtToSeal((MutableStatement)this);
        HashSet<IdentityEffectiveStatementImpl> derivedIdentitiesInit = new HashSet<IdentityEffectiveStatementImpl>();
        List derivedIdentitiesCtxList = (List)ctx.getFromNamespace(DerivedIdentitiesNamespace.class, ctx.coerceStatementArgument());
        if (derivedIdentitiesCtxList == null) {
            this.derivedIdentities = ImmutableSet.of();
            return;
        }
        for (StmtContext derivedIdentityCtx : derivedIdentitiesCtxList) {
            IdentityEffectiveStatementImpl derivedIdentity = (IdentityEffectiveStatementImpl)derivedIdentityCtx.buildEffective();
            derivedIdentity.addBaseIdentity(this);
            derivedIdentitiesInit.add(derivedIdentity);
        }
        this.derivedIdentities = ImmutableSet.copyOf(derivedIdentitiesInit);
    }

    private void addBaseIdentity(IdentityEffectiveStatementImpl baseIdentity) {
        Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (String)"Attempt to modify sealed identity effective statement %s", (Object)this.getQName());
        this.baseIdentities.add(baseIdentity);
    }

    public Set<IdentitySchemaNode> getBaseIdentities() {
        Preconditions.checkState((boolean)this.sealed, (String)"Attempt to get base identities from unsealed identity effective statement %s", (Object)this.getQName());
        return this.baseIdentities;
    }

    public Set<IdentitySchemaNode> getDerivedIdentities() {
        return Collections.unmodifiableSet(this.derivedIdentities);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getQName());
        result = 31 * result + Objects.hashCode(this.getPath());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentityEffectiveStatementImpl other = (IdentityEffectiveStatementImpl)obj;
        return Objects.equals(this.getQName(), other.getQName()) && Objects.equals(this.getPath(), other.getPath());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("qname", (Object)this.getQName()).add("path", (Object)this.getPath()).toString();
    }

    public void seal() {
        if (!this.sealed) {
            this.baseIdentities = ImmutableSet.copyOf(this.baseIdentities);
            this.sealed = true;
        }
    }
}

