/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_;

import com.google.common.base.Verify;
import java.net.URI;
import java.util.Collection;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.ImportEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.ImportStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.RevisionImport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.SemanticVersionImport;
import org.opendaylight.yangtools.yang.parser.spi.PreLinkageModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImpPrefixToNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractImportStatementSupport
extends AbstractStatementSupport<String, ImportStatement, EffectiveStatement<String, ImportStatement>> {
    AbstractImportStatementSupport() {
        super((StatementDefinition)YangStmtMapping.IMPORT);
    }

    public final String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public final ImportStatement createDeclared(StmtContext<String, ImportStatement, ?> ctx) {
        return new ImportStatementImpl(ctx);
    }

    public final EffectiveStatement<String, ImportStatement> createEffective(StmtContext<String, ImportStatement, EffectiveStatement<String, ImportStatement>> ctx) {
        return new ImportEffectiveStatementImpl(ctx);
    }

    public final void onPreLinkageDeclared(final StmtContext.Mutable<String, ImportStatement, EffectiveStatement<String, ImportStatement>> stmt) {
        stmt.addRequiredSource(RevisionImport.getImportedSourceIdentifier(stmt));
        final String moduleName = (String)stmt.coerceStatementArgument();
        ModelActionBuilder importAction = stmt.newInferenceAction(ModelProcessingPhase.SOURCE_PRE_LINKAGE);
        final ModelActionBuilder.Prerequisite imported = importAction.requiresCtx(stmt, PreLinkageModuleNamespace.class, (Object)moduleName, ModelProcessingPhase.SOURCE_PRE_LINKAGE);
        ModelActionBuilder.Prerequisite linkageTarget = importAction.mutatesCtx(stmt.getRoot(), ModelProcessingPhase.SOURCE_PRE_LINKAGE);
        importAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StmtContext importedModuleContext = (StmtContext)imported.resolve(ctx);
                Verify.verify((boolean)moduleName.equals(importedModuleContext.getStatementArgument()));
                URI importedModuleNamespace = (URI)importedModuleContext.getFromNamespace(ModuleNameToNamespace.class, (Object)moduleName);
                Verify.verifyNotNull((Object)importedModuleNamespace);
                String impPrefix = (String)SourceException.throwIfNull((Object)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class), (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Missing prefix statement", (Object[])new Object[0]);
                stmt.addToNs(ImpPrefixToNamespace.class, (Object)impPrefix, (Object)importedModuleNamespace);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(imported), (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Imported module [%s] was not found.", (Object[])new Object[]{moduleName});
            }
        });
    }

    public final void onLinkageDeclared(StmtContext.Mutable<String, ImportStatement, EffectiveStatement<String, ImportStatement>> stmt) {
        if (stmt.isEnabledSemanticVersioning()) {
            SemanticVersionImport.onLinkageDeclared(stmt);
        } else {
            RevisionImport.onLinkageDeclared(stmt);
        }
    }
}

