/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.key;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.key.KeyEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.key.KeyStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameCacheNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class KeyStatementSupport
extends AbstractStatementSupport<Collection<SchemaNodeIdentifier>, KeyStatement, EffectiveStatement<Collection<SchemaNodeIdentifier>, KeyStatement>> {
    private static final Splitter LIST_KEY_SPLITTER = Splitter.on((char)' ').omitEmptyStrings().trimResults();
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.KEY).build();
    private static final KeyStatementSupport INSTANCE = new KeyStatementSupport();

    private KeyStatementSupport() {
        super((StatementDefinition)YangStmtMapping.KEY);
    }

    public static KeyStatementSupport getInstance() {
        return INSTANCE;
    }

    public Collection<SchemaNodeIdentifier> parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int tokens = 0;
        for (String keyToken : LIST_KEY_SPLITTER.split((CharSequence)value)) {
            builder.add((Object)SchemaNodeIdentifier.SAME.createChild(StmtContextUtils.parseNodeIdentifier(ctx, (String)keyToken)));
            ++tokens;
        }
        ImmutableSet ret = builder.build();
        SourceException.throwIf((ret.size() != tokens ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Key argument '%s' contains duplicates", (Object[])new Object[]{value});
        return ret;
    }

    public Collection<SchemaNodeIdentifier> adaptArgumentValue(StmtContext<Collection<SchemaNodeIdentifier>, KeyStatement, EffectiveStatement<Collection<SchemaNodeIdentifier>, KeyStatement>> ctx, QNameModule targetModule) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        boolean replaced = false;
        for (SchemaNodeIdentifier arg : (Collection)ctx.coerceStatementArgument()) {
            QName qname = arg.getLastComponent();
            if (!targetModule.equals((Object)qname.getModule())) {
                QName newQname = (QName)ctx.getFromNamespace(QNameCacheNamespace.class, (Object)qname.withModule(targetModule));
                builder.add((Object)SchemaNodeIdentifier.SAME.createChild(newQname));
                replaced = true;
                continue;
            }
            builder.add((Object)arg);
        }
        return replaced ? builder.build() : (Collection)ctx.getStatementArgument();
    }

    public KeyStatement createDeclared(StmtContext<Collection<SchemaNodeIdentifier>, KeyStatement, ?> ctx) {
        return new KeyStatementImpl(ctx);
    }

    public EffectiveStatement<Collection<SchemaNodeIdentifier>, KeyStatement> createEffective(StmtContext<Collection<SchemaNodeIdentifier>, KeyStatement, EffectiveStatement<Collection<SchemaNodeIdentifier>, KeyStatement>> ctx) {
        return new KeyEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

