/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.list;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.UniqueConstraint;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveSimpleDataNodeContainer;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public final class ListEffectiveStatementImpl
extends AbstractEffectiveSimpleDataNodeContainer<ListStatement>
implements ListEffectiveStatement,
ListSchemaNode,
DerivableSchemaNode {
    private static final String ORDER_BY_USER_KEYWORD = "user";
    private final boolean userOrdered;
    private final ImmutableList<QName> keyDefinition;
    private final ListSchemaNode original;
    private final @NonNull ImmutableSet<ActionDefinition> actions;
    private final @NonNull ImmutableSet<NotificationDefinition> notifications;
    private final @NonNull ImmutableList<UniqueConstraint> uniqueConstraints;
    private final ElementCountConstraint elementCountConstraint;
    private final ImmutableSet<MustDefinition> mustConstraints;

    ListEffectiveStatementImpl(StmtContext<QName, ListStatement, EffectiveStatement<QName, ListStatement>> ctx) {
        super(ctx);
        this.original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        this.userOrdered = this.findFirstEffectiveSubstatementArgument(OrderedByEffectiveStatement.class).map(ORDER_BY_USER_KEYWORD::equals).orElse(Boolean.FALSE);
        Optional optKeyStmt = this.findFirstEffectiveSubstatement(KeyEffectiveStatement.class);
        if (optKeyStmt.isPresent()) {
            KeyEffectiveStatement keyStmt = (KeyEffectiveStatement)optKeyStmt.get();
            ArrayList<QName> keyDefinitionInit = new ArrayList<QName>(((Collection)keyStmt.argument()).size());
            HashSet<QName> possibleLeafQNamesForKey = new HashSet<QName>();
            for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
                if (!(effectiveStatement instanceof LeafSchemaNode)) continue;
                possibleLeafQNamesForKey.add(((LeafSchemaNode)effectiveStatement).getQName());
            }
            for (SchemaNodeIdentifier key : (Collection)keyStmt.argument()) {
                QName keyQName = key.getLastComponent();
                if (!possibleLeafQNamesForKey.contains(keyQName)) {
                    throw new InferenceException(ctx.getStatementSourceReference(), "Key '%s' misses node '%s' in list '%s'", new Object[]{((KeyStatement)keyStmt.getDeclared()).rawArgument(), keyQName.getLocalName(), ctx.getStatementArgument()});
                }
                keyDefinitionInit.add(keyQName);
            }
            this.keyDefinition = ImmutableList.copyOf(keyDefinitionInit);
        } else {
            this.keyDefinition = ImmutableList.of();
        }
        this.uniqueConstraints = ImmutableList.copyOf(this.allSubstatementsOfType(UniqueConstraint.class));
        ImmutableSet.Builder actionsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder notificationsBuilder = ImmutableSet.builder();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (effectiveStatement instanceof ActionDefinition) {
                actionsBuilder.add((Object)((ActionDefinition)effectiveStatement));
            }
            if (!(effectiveStatement instanceof NotificationDefinition)) continue;
            notificationsBuilder.add((Object)((NotificationDefinition)effectiveStatement));
        }
        this.actions = actionsBuilder.build();
        this.notifications = notificationsBuilder.build();
        this.elementCountConstraint = EffectiveStmtUtils.createElementCountConstraint(this).orElse(null);
        this.mustConstraints = ImmutableSet.copyOf(this.allSubstatementsOfType(MustDefinition.class));
    }

    public Optional<ListSchemaNode> getOriginal() {
        return Optional.ofNullable(this.original);
    }

    public List<QName> getKeyDefinition() {
        return this.keyDefinition;
    }

    public Set<ActionDefinition> getActions() {
        return this.actions;
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.notifications;
    }

    public Collection<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public boolean isUserOrdered() {
        return this.userOrdered;
    }

    public Optional<ElementCountConstraint> getElementCountConstraint() {
        return Optional.ofNullable(this.elementCountConstraint);
    }

    public Collection<MustDefinition> getMustConstraints() {
        return this.mustConstraints;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getQName());
        result = 31 * result + Objects.hashCode(this.getPath());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListEffectiveStatementImpl other = (ListEffectiveStatementImpl)obj;
        return Objects.equals(this.getQName(), other.getQName()) && Objects.equals(this.getPath(), other.getPath());
    }

    public String toString() {
        return "list " + this.getQName().getLocalName();
    }
}

