/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.mandatory;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.mandatory.EmptyMandatoryEffectiveStatement;

abstract class EmptyMandatoryStatement
implements MandatoryStatement {
    static final @NonNull MandatoryStatement FALSE = new EmptyMandatoryStatement(){

        public Boolean argument() {
            return Boolean.FALSE;
        }

        @Override
        EffectiveStatement<Boolean, MandatoryStatement> toEffective() {
            return EmptyMandatoryEffectiveStatement.FALSE;
        }
    };
    static final @NonNull MandatoryStatement TRUE = new EmptyMandatoryStatement(){

        public Boolean argument() {
            return Boolean.TRUE;
        }

        @Override
        EffectiveStatement<Boolean, MandatoryStatement> toEffective() {
            return EmptyMandatoryEffectiveStatement.TRUE;
        }
    };

    EmptyMandatoryStatement() {
    }

    abstract EffectiveStatement<Boolean, MandatoryStatement> toEffective();

    public final Collection<? extends DeclaredStatement<?>> declaredSubstatements() {
        return ImmutableList.of();
    }

    public final StatementDefinition statementDefinition() {
        return YangStmtMapping.MANDATORY;
    }

    public final String rawArgument() {
        return this.getValue().toString();
    }

    public final StatementSource getStatementSource() {
        return StatementSource.DECLARATION;
    }

    public final int hashCode() {
        return Objects.hash(this.statementDefinition(), this.getStatementSource(), this.argument(), this.rawArgument(), this.declaredSubstatements(), this.getValue());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MandatoryStatement)) {
            return false;
        }
        MandatoryStatement other = (MandatoryStatement)obj;
        return ((Boolean)this.argument()).equals(other.argument()) && this.rawArgument().equals(other.rawArgument()) && this.getValue().equals(other.getValue()) && this.statementDefinition().equals(other.statementDefinition()) && this.getStatementSource().equals((Object)other.getStatementSource()) && this.declaredSubstatements().equals(other.declaredSubstatements());
    }
}

