/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.must;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ErrorAppTagEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ErrorMessageEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MustEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MustStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class MustEffectiveStatementImpl
extends DeclaredEffectiveStatementBase<RevisionAwareXPath, MustStatement>
implements MustDefinition,
MustEffectiveStatement {
    private final RevisionAwareXPath xpath;
    private final String description;
    private final String errorAppTag;
    private final String errorMessage;
    private final String reference;

    MustEffectiveStatementImpl(StmtContext<RevisionAwareXPath, MustStatement, ?> ctx) {
        super(ctx);
        this.xpath = (RevisionAwareXPath)ctx.getStatementArgument();
        this.description = this.findFirstEffectiveSubstatementArgument(DescriptionEffectiveStatement.class).orElse(null);
        this.errorAppTag = this.findFirstEffectiveSubstatementArgument(ErrorAppTagEffectiveStatement.class).orElse(null);
        this.errorMessage = this.findFirstEffectiveSubstatementArgument(ErrorMessageEffectiveStatement.class).orElse(null);
        this.reference = this.findFirstEffectiveSubstatementArgument(ReferenceEffectiveStatement.class).orElse(null);
    }

    public RevisionAwareXPath getXpath() {
        return this.xpath;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getErrorAppTag() {
        return Optional.ofNullable(this.errorAppTag);
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public int hashCode() {
        return Objects.hash(this.xpath, this.description, this.reference);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MustEffectiveStatementImpl)) {
            return false;
        }
        MustEffectiveStatementImpl other = (MustEffectiveStatementImpl)obj;
        return Objects.equals(this.xpath, other.xpath) && Objects.equals(this.description, other.description) && Objects.equals(this.reference, other.reference);
    }

    public String toString() {
        return this.xpath.toString();
    }
}

