/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.notification;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedDataNodeContainer;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class NotificationEffectiveStatementImpl
extends AbstractEffectiveDocumentedDataNodeContainer<QName, NotificationStatement>
implements NotificationDefinition,
NotificationEffectiveStatement {
    private final @NonNull QName qname;
    private final @NonNull SchemaPath path;
    private final ImmutableSet<AugmentationSchemaNode> augmentations;
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownNodes;
    private final boolean augmenting;
    private final boolean addedByUses;
    private final ImmutableSet<MustDefinition> mustConstraints;

    NotificationEffectiveStatementImpl(StmtContext<QName, NotificationStatement, EffectiveStatement<QName, NotificationStatement>> ctx) {
        super(ctx);
        this.qname = (QName)ctx.coerceStatementArgument();
        this.path = (SchemaPath)ctx.getSchemaPath().get();
        ArrayList<UnknownSchemaNode> unknownNodesInit = new ArrayList<UnknownSchemaNode>();
        LinkedHashSet<AugmentationSchemaNode> augmentationsInit = new LinkedHashSet<AugmentationSchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (effectiveStatement instanceof UnknownSchemaNode) {
                UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
                unknownNodesInit.add(unknownNode);
            }
            if (!(effectiveStatement instanceof AugmentationSchemaNode)) continue;
            AugmentationSchemaNode augmentationSchema = (AugmentationSchemaNode)effectiveStatement;
            augmentationsInit.add(augmentationSchema);
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
        this.augmentations = ImmutableSet.copyOf(augmentationsInit);
        this.mustConstraints = ImmutableSet.copyOf(this.allSubstatementsOfType(MustDefinition.class));
        CopyHistory copyTypesFromOriginal = ctx.getCopyHistory();
        if (copyTypesFromOriginal.contains(CopyType.ADDED_BY_USES_AUGMENTATION)) {
            this.augmenting = true;
            this.addedByUses = true;
        } else {
            this.augmenting = copyTypesFromOriginal.contains(CopyType.ADDED_BY_AUGMENTATION);
            this.addedByUses = copyTypesFromOriginal.contains(CopyType.ADDED_BY_USES);
        }
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public Collection<MustDefinition> getMustConstraints() {
        return this.mustConstraints;
    }

    public Set<AugmentationSchemaNode> getAvailableAugmentations() {
        return this.augmentations;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    @Deprecated
    public boolean isAugmenting() {
        return this.augmenting;
    }

    @Deprecated
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.qname);
        result = 31 * result + Objects.hashCode(this.path);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotificationEffectiveStatementImpl other = (NotificationEffectiveStatementImpl)obj;
        return Objects.equals(this.qname, other.qname) && Objects.equals(this.path, other.path);
    }

    public String toString() {
        return NotificationEffectiveStatementImpl.class.getSimpleName() + "[qname=" + this.qname + ", path=" + this.path + "]";
    }
}

