/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.notification;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.notification.AbstractNotificationStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.notification.NotificationEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@Beta
public final class NotificationStatementRFC7950Support
extends AbstractNotificationStatementSupport {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.NOTIFICATION).addAny((StatementDefinition)YangStmtMapping.ANYDATA).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CHOICE).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.USES).build();
    private static final Set<StatementDefinition> ILLEGAL_PARENTS = ImmutableSet.of((Object)YangStmtMapping.NOTIFICATION, (Object)YangStmtMapping.RPC, (Object)YangStmtMapping.ACTION);
    private static final NotificationStatementRFC7950Support INSTANCE = new NotificationStatementRFC7950Support();

    private NotificationStatementRFC7950Support() {
    }

    public static NotificationStatementRFC7950Support getInstance() {
        return INSTANCE;
    }

    public EffectiveStatement<QName, NotificationStatement> createEffective(StmtContext<QName, NotificationStatement, EffectiveStatement<QName, NotificationStatement>> ctx) {
        SourceException.throwIf((boolean)StmtContextUtils.hasAncestorOfType(ctx, ILLEGAL_PARENTS), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Notification %s is defined within an rpc, action, or another notification", (Object[])new Object[]{ctx.getStatementArgument()});
        SourceException.throwIf((!StmtContextUtils.hasAncestorOfTypeWithChildOfType(ctx, (StatementDefinition)YangStmtMapping.LIST, (StatementDefinition)YangStmtMapping.KEY) ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Notification %s is defined within a list that has no key statement", (Object[])new Object[]{ctx.getStatementArgument()});
        SourceException.throwIf((boolean)StmtContextUtils.hasParentOfType(ctx, (StatementDefinition)YangStmtMapping.CASE), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Notification %s is defined within a case statement", (Object[])new Object[]{ctx.getStatementArgument()});
        return new NotificationEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

