/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.refine;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public final class RefineEffectiveStatementImpl
extends AbstractEffectiveDocumentedNode<SchemaNodeIdentifier, RefineStatement>
implements RefineEffectiveStatement,
SchemaNode {
    private final @NonNull QName qname;
    private final @NonNull SchemaPath path;
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownNodes;
    private final SchemaNode refineTargetNode;

    RefineEffectiveStatementImpl(StmtContext<SchemaNodeIdentifier, RefineStatement, ?> ctx) {
        super(ctx);
        this.qname = (QName)Verify.verifyNotNull((Object)((SchemaNodeIdentifier)ctx.coerceStatementArgument()).getLastComponent());
        this.path = (SchemaPath)ctx.getSchemaPath().get();
        this.refineTargetNode = (SchemaNode)((StmtContext)ctx.getEffectOfStatement().iterator().next()).buildEffective();
        this.unknownNodes = ImmutableList.copyOf((Collection)this.effectiveSubstatements().stream().filter(UnknownSchemaNode.class::isInstance).map(UnknownSchemaNode.class::cast).collect(Collectors.toList()));
    }

    public SchemaNode getRefineTargetNode() {
        return this.refineTargetNode;
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }
}

