/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision;

import java.time.format.DateTimeParseException;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision.RevisionEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision.RevisionStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class RevisionStatementSupport
extends AbstractStatementSupport<Revision, RevisionStatement, EffectiveStatement<Revision, RevisionStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.REVISION).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();
    private static final RevisionStatementSupport INSTANCE = new RevisionStatementSupport();

    private RevisionStatementSupport() {
        super((StatementDefinition)YangStmtMapping.REVISION);
    }

    public static RevisionStatementSupport getInstance() {
        return INSTANCE;
    }

    public Revision parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Revision.of((String)value);
        }
        catch (DateTimeParseException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Revision value %s is not in required format yyyy-MM-dd", new Object[]{value});
        }
    }

    public RevisionStatement createDeclared(StmtContext<Revision, RevisionStatement, ?> ctx) {
        return new RevisionStatementImpl(ctx);
    }

    public EffectiveStatement<Revision, RevisionStatement> createEffective(StmtContext<Revision, RevisionStatement, EffectiveStatement<Revision, RevisionStatement>> ctx) {
        return new RevisionEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

