/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.IdentityRefSpecificationEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.IdentityRefSpecificationImpl;
import org.opendaylight.yangtools.yang.parser.spi.IdentityNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractIdentityRefSpecificationSupport
extends AbstractStatementSupport<String, TypeStatement.IdentityRefSpecification, EffectiveStatement<String, TypeStatement.IdentityRefSpecification>> {
    AbstractIdentityRefSpecificationSupport() {
        super((StatementDefinition)YangStmtMapping.TYPE);
    }

    public final String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public final TypeStatement.IdentityRefSpecification createDeclared(StmtContext<String, TypeStatement.IdentityRefSpecification, ?> ctx) {
        return new IdentityRefSpecificationImpl(ctx);
    }

    public final EffectiveStatement<String, TypeStatement.IdentityRefSpecification> createEffective(StmtContext<String, TypeStatement.IdentityRefSpecification, EffectiveStatement<String, TypeStatement.IdentityRefSpecification>> ctx) {
        return new IdentityRefSpecificationEffectiveStatement(ctx);
    }

    public final void onFullDefinitionDeclared(StmtContext.Mutable<String, TypeStatement.IdentityRefSpecification, EffectiveStatement<String, TypeStatement.IdentityRefSpecification>> stmt) {
        super.onFullDefinitionDeclared(stmt);
        Collection baseStatements = StmtContextUtils.findAllDeclaredSubstatements(stmt, BaseStatement.class);
        for (StmtContext baseStmt : baseStatements) {
            QName baseIdentity = (QName)baseStmt.coerceStatementArgument();
            StmtContext stmtCtx = (StmtContext)stmt.getFromNamespace(IdentityNamespace.class, (Object)baseIdentity);
            InferenceException.throwIfNull((Object)stmtCtx, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Referenced base identity '%s' doesn't exist in given scope (module, imported modules, submodules)", (Object[])new Object[]{baseIdentity.getLocalName()});
        }
    }
}

