/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.EnumerationTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.enum_.EnumEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EffectiveTypeUtil;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class EnumTypeEffectiveStatementImpl
extends DeclaredEffectiveStatementBase<String, TypeStatement>
implements TypeEffectiveStatement<TypeStatement> {
    private final @NonNull EnumTypeDefinition typeDefinition;

    EnumTypeEffectiveStatementImpl(StmtContext<String, TypeStatement, EffectiveStatement<String, TypeStatement>> ctx, EnumTypeDefinition baseType) {
        super(ctx);
        EnumerationTypeBuilder builder = RestrictedTypes.newEnumerationBuilder((EnumTypeDefinition)baseType, (SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        YangVersion yangVersion = ctx.getRootVersion();
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof EnumEffectiveStatementImpl) {
                SourceException.throwIf((yangVersion != YangVersion.VERSION_1_1 ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Restricted enumeration type is allowed only in YANG 1.1 version.", (Object[])new Object[0]);
                EnumEffectiveStatementImpl enumSubStmt = (EnumEffectiveStatementImpl)stmt;
                int effectiveValue = enumSubStmt.getDeclaredValue() == null ? EnumTypeEffectiveStatementImpl.getBaseTypeEnumValue(enumSubStmt.getName(), baseType, ctx) : enumSubStmt.getDeclaredValue();
                builder.addEnum(EffectiveTypeUtil.buildEnumPair(enumSubStmt, effectiveValue));
                continue;
            }
            if (!(stmt instanceof UnknownSchemaNode)) continue;
            builder.addUnknownSchemaNode((UnknownSchemaNode)stmt);
        }
        this.typeDefinition = (EnumTypeDefinition)builder.build();
    }

    private static int getBaseTypeEnumValue(String enumName, EnumTypeDefinition baseType, StmtContext<?, ?, ?> ctx) {
        for (EnumTypeDefinition.EnumPair baseTypeEnumPair : baseType.getValues()) {
            if (!enumName.equals(baseTypeEnumPair.getName())) continue;
            return baseTypeEnumPair.getValue();
        }
        throw new SourceException(ctx.getStatementSourceReference(), "Enum '%s' is not a subset of its base enumeration type %s.", new Object[]{enumName, baseType.getQName()});
    }

    public EnumTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }
}

