/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.InvalidLengthConstraintException;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedTypes;
import org.opendaylight.yangtools.yang.model.util.type.StringTypeBuilder;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.length.LengthEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StringTypeEffectiveStatementImpl
extends DeclaredEffectiveStatementBase<String, TypeStatement>
implements TypeEffectiveStatement<TypeStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(StringTypeEffectiveStatementImpl.class);
    private final @NonNull StringTypeDefinition typeDefinition;

    StringTypeEffectiveStatementImpl(StmtContext<String, TypeStatement, EffectiveStatement<String, TypeStatement>> ctx, StringTypeDefinition baseType) {
        super(ctx);
        StringTypeBuilder builder = RestrictedTypes.newStringBuilder((StringTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx));
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof LengthEffectiveStatementImpl) {
                LengthEffectiveStatementImpl length = (LengthEffectiveStatementImpl)stmt;
                try {
                    builder.setLengthConstraint((ConstraintMetaDefinition)length, (List)length.argument());
                }
                catch (IllegalStateException e) {
                    throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Multiple length constraints encountered", new Object[0]);
                }
                catch (InvalidLengthConstraintException e) {
                    throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Invalid length constraint %s", new Object[]{length.argument()});
                }
            }
            if (stmt instanceof PatternEffectiveStatement) {
                PatternConstraint pattern = (PatternConstraint)((PatternEffectiveStatement)stmt).argument();
                if (pattern != null) {
                    builder.addPatternConstraint(pattern);
                } else {
                    LOG.debug("Ignoring empty pattern statement {}", stmt);
                }
            }
            if (!(stmt instanceof UnknownSchemaNode)) continue;
            builder.addUnknownSchemaNode((UnknownSchemaNode)stmt);
        }
        this.typeDefinition = (StringTypeDefinition)builder.build();
    }

    public StringTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }
}

