/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.typedef;

import java.util.Collection;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.type.DerivedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.DerivedTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveSchemaNode;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TypedefEffectiveStatementImpl
extends AbstractEffectiveSchemaNode<TypedefStatement>
implements TypedefEffectiveStatement {
    private static final Logger LOG = LoggerFactory.getLogger(TypedefEffectiveStatementImpl.class);
    private final @NonNull TypeDefinition<?> typeDefinition;
    private volatile TypeEffectiveStatement<TypeStatement> typeStatement;

    TypedefEffectiveStatementImpl(StmtContext<QName, TypedefStatement, ?> ctx) {
        super(ctx);
        TypeEffectiveStatement typeEffectiveStmt = this.firstSubstatementOfType(TypeEffectiveStatement.class);
        DerivedTypeBuilder builder = DerivedTypes.derivedTypeBuilder((TypeDefinition)typeEffectiveStmt.getTypeDefinition(), (SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        String dflt = null;
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof DefaultEffectiveStatement) {
                dflt = (String)((DefaultEffectiveStatement)stmt).argument();
                builder.setDefaultValue((Object)dflt);
                continue;
            }
            if (stmt instanceof DescriptionEffectiveStatement) {
                builder.setDescription((String)((DescriptionEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof ReferenceEffectiveStatement) {
                builder.setReference((String)((ReferenceEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof StatusEffectiveStatement) {
                builder.setStatus((Status)((StatusEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof UnitsEffectiveStatement) {
                builder.setUnits((String)((UnitsEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof UnknownSchemaNode) {
                builder.addUnknownSchemaNode((UnknownSchemaNode)stmt);
                continue;
            }
            if (stmt instanceof TypeEffectiveStatement) continue;
            LOG.debug("Ignoring statement {}", stmt);
        }
        SourceException.throwIf((boolean)EffectiveStmtUtils.hasDefaultValueMarkedWithIfFeature(ctx.getRootVersion(), typeEffectiveStmt, dflt), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Typedef '%s' has default value '%s' marked with an if-feature statement.", (Object[])new Object[]{ctx.getStatementArgument(), dflt});
        this.typeDefinition = (TypeDefinition)builder.build();
    }

    public TypeDefinition<?> getTypeDefinition() {
        return this.typeDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeEffectiveStatement<TypeStatement> asTypeEffectiveStatement() {
        ProxyTypeEffectiveStatement ret = this.typeStatement;
        if (ret == null) {
            TypedefEffectiveStatementImpl typedefEffectiveStatementImpl = this;
            synchronized (typedefEffectiveStatementImpl) {
                ret = this.typeStatement;
                if (ret == null) {
                    this.typeStatement = ret = new ProxyTypeEffectiveStatement();
                }
            }
        }
        return ret;
    }

    private final class ProxyTypeEffectiveStatement
    implements TypeEffectiveStatement<TypeStatement> {
        private ProxyTypeEffectiveStatement() {
        }

        public TypeStatement getDeclared() {
            return null;
        }

        public <K, V, N extends IdentifierNamespace<K, V>> V get(Class<N> namespace, K identifier) {
            return TypedefEffectiveStatementImpl.this.get(namespace, identifier);
        }

        public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAll(Class<N> namespace) {
            return TypedefEffectiveStatementImpl.this.getAll(namespace);
        }

        public Collection<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
            return TypedefEffectiveStatementImpl.this.effectiveSubstatements();
        }

        public StatementDefinition statementDefinition() {
            return YangStmtMapping.TYPE;
        }

        public String argument() {
            return TypedefEffectiveStatementImpl.this.getQName().getLocalName();
        }

        public StatementSource getStatementSource() {
            return StatementSource.CONTEXT;
        }

        public TypeDefinition<?> getTypeDefinition() {
            return TypedefEffectiveStatementImpl.this.getTypeDefinition();
        }
    }
}

