/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.typedef;

import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.typedef.TypedefEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.typedef.TypedefStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.TypeNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class TypedefStatementSupport
extends AbstractQNameStatementSupport<TypedefStatement, EffectiveStatement<QName, TypedefStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPEDEF).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addMandatory((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();
    private static final TypedefStatementSupport INSTANCE = new TypedefStatementSupport();

    private TypedefStatementSupport() {
        super((StatementDefinition)YangStmtMapping.TYPEDEF);
    }

    public static TypedefStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public TypedefStatement createDeclared(StmtContext<QName, TypedefStatement, ?> ctx) {
        StmtContext grandParent;
        StmtContext parent = ctx.getParentContext();
        if (parent != null && (grandParent = parent.getParentContext()) != null) {
            TypedefStatementSupport.checkConflict(grandParent, ctx);
        }
        return new TypedefStatementImpl(ctx);
    }

    public EffectiveStatement<QName, TypedefStatement> createEffective(StmtContext<QName, TypedefStatement, EffectiveStatement<QName, TypedefStatement>> ctx) {
        return new TypedefEffectiveStatementImpl(ctx);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, TypedefStatement, EffectiveStatement<QName, TypedefStatement>> stmt) {
        StmtContext.Mutable parent;
        super.onFullDefinitionDeclared(stmt);
        if (stmt != null && (parent = stmt.getParentContext()) != null) {
            TypedefStatementSupport.checkConflict(parent, stmt);
            parent.addContext(TypeNamespace.class, stmt.coerceStatementArgument(), stmt);
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    private static void checkConflict(StmtContext<?, ?, ?> parent, StmtContext<QName, ?, ?> stmt) {
        QName arg = (QName)stmt.coerceStatementArgument();
        StmtContext existing = (StmtContext)parent.getFromNamespace(TypeNamespace.class, (Object)arg);
        SourceException.throwIf((existing != null ? 1 : 0) != 0, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Duplicate name for typedef %s", (Object[])new Object[]{arg});
    }
}

