/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.value;

import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.value.ValueEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.value.ValueStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class ValueStatementSupport
extends AbstractStatementSupport<Integer, ValueStatement, EffectiveStatement<Integer, ValueStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.VALUE).build();
    private static final ValueStatementSupport INSTANCE = new ValueStatementSupport();

    private ValueStatementSupport() {
        super((StatementDefinition)YangStmtMapping.VALUE);
    }

    public static ValueStatementSupport getInstance() {
        return INSTANCE;
    }

    public Integer parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "%s is not valid value statement integer argument in a range of -2147483648..2147483647", new Object[]{value});
        }
    }

    public ValueStatement createDeclared(StmtContext<Integer, ValueStatement, ?> ctx) {
        return new ValueStatementImpl(ctx);
    }

    public EffectiveStatement<Integer, ValueStatement> createEffective(StmtContext<Integer, ValueStatement, EffectiveStatement<Integer, ValueStatement>> ctx) {
        return new ValueEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

