/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.Servlet;
import org.immutables.value.Generated;
import org.opendaylight.aaa.web.ServletDetails;

@ParametersAreNonnullByDefault
@Generated(from="ServletDetails", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class ServletDetailsBuilder {
    private static final long INIT_BIT_SERVLET = 1L;
    private long initBits = 1L;
    @Nullable
    private Servlet servlet;
    @Nullable
    private String name;
    private List<String> urlPatterns = new ArrayList<String>();
    private Map<String, String> initParams = new LinkedHashMap<String, String>();

    public final ServletDetailsBuilder from(ServletDetails instance) {
        Objects.requireNonNull(instance, "instance");
        this.servlet(instance.servlet());
        this.name(instance.name());
        this.addAllUrlPatterns(instance.urlPatterns());
        this.putAllInitParams(instance.initParams());
        return this;
    }

    public final ServletDetailsBuilder servlet(Servlet servlet) {
        this.servlet = Objects.requireNonNull(servlet, "servlet");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final ServletDetailsBuilder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        return this;
    }

    public final ServletDetailsBuilder addUrlPattern(String element) {
        this.urlPatterns.add(Objects.requireNonNull(element, "urlPatterns element"));
        return this;
    }

    public final ServletDetailsBuilder addUrlPatterns(String ... elements) {
        for (String element : elements) {
            this.urlPatterns.add(Objects.requireNonNull(element, "urlPatterns element"));
        }
        return this;
    }

    public final ServletDetailsBuilder urlPatterns(Iterable<String> elements) {
        this.urlPatterns.clear();
        return this.addAllUrlPatterns(elements);
    }

    public final ServletDetailsBuilder addAllUrlPatterns(Iterable<String> elements) {
        for (String element : elements) {
            this.urlPatterns.add(Objects.requireNonNull(element, "urlPatterns element"));
        }
        return this;
    }

    public final ServletDetailsBuilder putInitParam(String key, String value) {
        this.initParams.put(Objects.requireNonNull(key, "initParams key"), Objects.requireNonNull(value, "initParams value"));
        return this;
    }

    public final ServletDetailsBuilder putInitParam(Map.Entry<String, ? extends String> entry) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.initParams.put(Objects.requireNonNull(k, "initParams key"), Objects.requireNonNull(v, "initParams value"));
        return this;
    }

    public final ServletDetailsBuilder initParams(Map<String, ? extends String> entries) {
        this.initParams.clear();
        return this.putAllInitParams(entries);
    }

    public final ServletDetailsBuilder putAllInitParams(Map<String, ? extends String> entries) {
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.initParams.put(Objects.requireNonNull(k, "initParams key"), Objects.requireNonNull(v, "initParams value"));
        }
        return this;
    }

    public ServletDetails build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableServletDetails(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("servlet");
        }
        return "Cannot build ServletDetails, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ServletDetails", generator="Immutables")
    @Immutable
    private static final class ImmutableServletDetails
    implements ServletDetails {
        private final Servlet servlet;
        private final String name;
        private final List<String> urlPatterns;
        private final Map<String, String> initParams;

        private ImmutableServletDetails(ServletDetailsBuilder builder) {
            this.servlet = builder.servlet;
            this.urlPatterns = ServletDetailsBuilder.createUnmodifiableList(true, builder.urlPatterns);
            this.initParams = ServletDetailsBuilder.createUnmodifiableMap(false, false, builder.initParams);
            this.name = builder.name != null ? builder.name : Objects.requireNonNull(ServletDetails.super.name(), "name");
        }

        @Override
        public Servlet servlet() {
            return this.servlet;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<String> urlPatterns() {
            return this.urlPatterns;
        }

        @Override
        public Map<String, String> initParams() {
            return this.initParams;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableServletDetails && this.equalTo((ImmutableServletDetails)another);
        }

        private boolean equalTo(ImmutableServletDetails another) {
            return this.servlet.equals(another.servlet) && this.name.equals(another.name) && this.urlPatterns.equals(another.urlPatterns) && this.initParams.equals(another.initParams);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.servlet.hashCode();
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.urlPatterns.hashCode();
            h += (h << 5) + this.initParams.hashCode();
            return h;
        }

        public String toString() {
            return "ServletDetails{servlet=" + this.servlet + ", name=" + this.name + ", urlPatterns=" + this.urlPatterns + ", initParams=" + this.initParams + "}";
        }
    }
}

