/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.web;

import java.util.List;
import java.util.Map;
import javax.servlet.ServletContextListener;
import org.immutables.value.Value;
import org.opendaylight.aaa.web.FilterDetails;
import org.opendaylight.aaa.web.ResourceDetails;
import org.opendaylight.aaa.web.ServletDetails;
import org.opendaylight.aaa.web.WebContextBuilder;

@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PRIVATE, depluralize=true)
public abstract class WebContext {
    public static WebContextBuilder builder() {
        return new WebContextBuilder();
    }

    public abstract String contextPath();

    @Value.Default
    public boolean supportsSessions() {
        return true;
    }

    public abstract List<ServletDetails> servlets();

    public abstract List<FilterDetails> filters();

    public abstract List<ServletContextListener> listeners();

    public abstract List<ResourceDetails> resources();

    public abstract Map<String, String> contextParams();

    @Value.Check
    protected void check() {
        this.servlets().forEach(servlet -> {
            if (servlet.urlPatterns().isEmpty()) {
                throw new IllegalArgumentException("Servlet has no URL: " + servlet.name());
            }
        });
        this.filters().forEach(filter -> {
            if (filter.urlPatterns().isEmpty()) {
                throw new IllegalArgumentException("Filter has no URL: " + filter.name());
            }
        });
    }
}

