/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.store.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration;
import org.opendaylight.controller.sal.core.spi.data.AbstractDOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.concurrent.QueuedNotificationManager;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidates;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InMemoryDOMStoreTreeChangePublisher
extends AbstractDOMStoreTreeChangePublisher {
    private static final QueuedNotificationManager.Invoker<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> MANAGER_INVOKER = (listener, notification) -> ((DOMDataTreeChangeListener)listener.getInstance()).onDataTreeChanged(Collections.singletonList(notification));
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMStoreTreeChangePublisher.class);
    private final QueuedNotificationManager<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> notificationManager;

    InMemoryDOMStoreTreeChangePublisher(ExecutorService listenerExecutor, int maxQueueSize) {
        this.notificationManager = new QueuedNotificationManager((Executor)listenerExecutor, MANAGER_INVOKER, maxQueueSize, "DataTreeChangeListenerQueueMgr");
    }

    private InMemoryDOMStoreTreeChangePublisher(QueuedNotificationManager<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> notificationManager) {
        this.notificationManager = notificationManager;
    }

    QueuedNotificationManager<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> getNotificationManager() {
        return this.notificationManager;
    }

    protected void notifyListeners(Collection<AbstractDOMDataTreeChangeListenerRegistration<?>> registrations, YangInstanceIdentifier path, DataTreeCandidateNode node) {
        DataTreeCandidate candidate = DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)path, (DataTreeCandidateNode)node);
        for (AbstractDOMDataTreeChangeListenerRegistration<?> reg : registrations) {
            LOG.debug("Enqueueing candidate {} to registration {}", (Object)candidate, registrations);
            this.notificationManager.submitNotification(reg, (Object)candidate);
        }
    }

    protected synchronized void registrationRemoved(AbstractDOMDataTreeChangeListenerRegistration<?> registration) {
        LOG.debug("Closing registration {}", registration);
    }

    <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier treeId, L listener, DataTreeSnapshot snapshot) {
        AbstractDOMDataTreeChangeListenerRegistration reg = this.registerTreeChangeListener(treeId, listener);
        Optional node = snapshot.readNode(YangInstanceIdentifier.EMPTY);
        if (node.isPresent()) {
            DataTreeCandidate candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)YangInstanceIdentifier.EMPTY, (NormalizedNode)((NormalizedNode)node.get()));
            InMemoryDOMStoreTreeChangePublisher publisher = new InMemoryDOMStoreTreeChangePublisher(this.notificationManager);
            publisher.registerTreeChangeListener(treeId, listener);
            publisher.publishChange(candidate);
        }
        return reg;
    }

    synchronized void publishChange(@NonNull DataTreeCandidate candidate) {
        this.processCandidateTree(candidate);
    }
}

