/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.karaf.features.Blacklisting;
import org.apache.karaf.features.internal.model.Feature;

@XmlRootElement(name="features", namespace="http://karaf.apache.org/xmlns/features/v1.5.0")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="features", propOrder={"repository", "resourceRepository", "feature"})
public class Features
implements Blacklisting {
    @XmlSchemaType(name="anyURI")
    @XmlElement(name="repository", namespace="http://karaf.apache.org/xmlns/features/v1.5.0")
    protected List<String> repository;
    @XmlSchemaType(name="anyURI")
    @XmlElement(name="resource-repository", namespace="http://karaf.apache.org/xmlns/features/v1.5.0")
    protected List<String> resourceRepository;
    @XmlElement(name="feature", namespace="http://karaf.apache.org/xmlns/features/v1.5.0")
    protected List<Feature> feature;
    @XmlAttribute
    protected String name;
    @XmlTransient
    private String namespace;
    @XmlTransient
    private boolean blacklisted;

    public List<String> getRepository() {
        if (this.repository == null) {
            this.repository = new ArrayList<String>();
        }
        return this.repository;
    }

    public List<String> getResourceRepository() {
        if (this.resourceRepository == null) {
            this.resourceRepository = new ArrayList<String>();
        }
        return this.resourceRepository;
    }

    public List<Feature> getFeature() {
        if (this.feature == null) {
            this.feature = new ArrayList<Feature>();
        }
        return this.feature;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void postUnmarshall(String repositoryUri) {
        if (this.feature != null) {
            for (Feature f : this.feature) {
                f.setRepositoryUrl(repositoryUri);
                f.setNamespace(this.namespace);
                f.setResourceRepositories(this.getResourceRepository());
                f.postUnmarshall();
            }
        }
        Features.trim(this.repository);
        Features.trim(this.resourceRepository);
    }

    private static void trim(List<String> list) {
        if (list != null) {
            ListIterator<String> it = list.listIterator();
            while (it.hasNext()) {
                it.set(it.next().trim());
            }
        }
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isBlacklisted() {
        return this.blacklisted;
    }

    public void setBlacklisted(boolean blacklisted) {
        this.blacklisted = blacklisted;
    }
}

