/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class ServicePathIdType
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 1087390366458688546L;
    private final Long _value;

    private static void check_valueRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..16777215]]", (long)value);
    }

    @ConstructorProperties(value={"value"})
    public ServicePathIdType(Long _value) {
        if (_value != null) {
            ServicePathIdType.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public ServicePathIdType(ServicePathIdType source) {
        this._value = source._value;
    }

    public static ServicePathIdType getDefaultInstance(String defaultValue) {
        return new ServicePathIdType(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServicePathIdType other = (ServicePathIdType)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(ServicePathIdType.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

