/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.application.data;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.SimpleAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.application.data.ApplicationData;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ApplicationDataBuilder
implements Builder<ApplicationData> {
    private SimpleAddress _address;
    private Integer _ipTos;
    private PortNumber _localPortHigh;
    private PortNumber _localPortLow;
    private Short _protocol;
    private PortNumber _remotePortHigh;
    private PortNumber _remotePortLow;
    Map<Class<? extends Augmentation<ApplicationData>>, Augmentation<ApplicationData>> augmentation = Collections.emptyMap();

    public ApplicationDataBuilder() {
    }

    public ApplicationDataBuilder(ApplicationData base) {
        Map aug;
        this._address = base.getAddress();
        this._ipTos = base.getIpTos();
        this._localPortHigh = base.getLocalPortHigh();
        this._localPortLow = base.getLocalPortLow();
        this._protocol = base.getProtocol();
        this._remotePortHigh = base.getRemotePortHigh();
        this._remotePortLow = base.getRemotePortLow();
        if (base instanceof ApplicationDataImpl) {
            ApplicationDataImpl impl = (ApplicationDataImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ApplicationData>>, Augmentation<ApplicationData>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ApplicationData>>, Augmentation<ApplicationData>>(aug);
        }
    }

    public SimpleAddress getAddress() {
        return this._address;
    }

    public Integer getIpTos() {
        return this._ipTos;
    }

    public PortNumber getLocalPortHigh() {
        return this._localPortHigh;
    }

    public PortNumber getLocalPortLow() {
        return this._localPortLow;
    }

    public Short getProtocol() {
        return this._protocol;
    }

    public PortNumber getRemotePortHigh() {
        return this._remotePortHigh;
    }

    public PortNumber getRemotePortLow() {
        return this._remotePortLow;
    }

    public <E$$ extends Augmentation<ApplicationData>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ApplicationDataBuilder setAddress(SimpleAddress value) {
        this._address = value;
        return this;
    }

    public ApplicationDataBuilder setIpTos(Integer value) {
        this._ipTos = value;
        return this;
    }

    public ApplicationDataBuilder setLocalPortHigh(PortNumber value) {
        this._localPortHigh = value;
        return this;
    }

    public ApplicationDataBuilder setLocalPortLow(PortNumber value) {
        this._localPortLow = value;
        return this;
    }

    private static void checkProtocolRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (int)value);
    }

    public ApplicationDataBuilder setProtocol(Short value) {
        if (value != null) {
            ApplicationDataBuilder.checkProtocolRange(value);
        }
        this._protocol = value;
        return this;
    }

    public ApplicationDataBuilder setRemotePortHigh(PortNumber value) {
        this._remotePortHigh = value;
        return this;
    }

    public ApplicationDataBuilder setRemotePortLow(PortNumber value) {
        this._remotePortLow = value;
        return this;
    }

    public ApplicationDataBuilder addAugmentation(Class<? extends Augmentation<ApplicationData>> augmentationType, Augmentation<ApplicationData> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ApplicationData>>, Augmentation<ApplicationData>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ApplicationDataBuilder removeAugmentation(Class<? extends Augmentation<ApplicationData>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ApplicationData build() {
        return new ApplicationDataImpl(this);
    }

    private static final class ApplicationDataImpl
    implements ApplicationData {
        private final SimpleAddress _address;
        private final Integer _ipTos;
        private final PortNumber _localPortHigh;
        private final PortNumber _localPortLow;
        private final Short _protocol;
        private final PortNumber _remotePortHigh;
        private final PortNumber _remotePortLow;
        private Map<Class<? extends Augmentation<ApplicationData>>, Augmentation<ApplicationData>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ApplicationDataImpl(ApplicationDataBuilder base) {
            this._address = base.getAddress();
            this._ipTos = base.getIpTos();
            this._localPortHigh = base.getLocalPortHigh();
            this._localPortLow = base.getLocalPortLow();
            this._protocol = base.getProtocol();
            this._remotePortHigh = base.getRemotePortHigh();
            this._remotePortLow = base.getRemotePortLow();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ApplicationData> getImplementedInterface() {
            return ApplicationData.class;
        }

        @Override
        public SimpleAddress getAddress() {
            return this._address;
        }

        @Override
        public Integer getIpTos() {
            return this._ipTos;
        }

        @Override
        public PortNumber getLocalPortHigh() {
            return this._localPortHigh;
        }

        @Override
        public PortNumber getLocalPortLow() {
            return this._localPortLow;
        }

        @Override
        public Short getProtocol() {
            return this._protocol;
        }

        @Override
        public PortNumber getRemotePortHigh() {
            return this._remotePortHigh;
        }

        @Override
        public PortNumber getRemotePortLow() {
            return this._remotePortLow;
        }

        public <E$$ extends Augmentation<ApplicationData>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._address);
            result = 31 * result + Objects.hashCode(this._ipTos);
            result = 31 * result + Objects.hashCode(this._localPortHigh);
            result = 31 * result + Objects.hashCode(this._localPortLow);
            result = 31 * result + Objects.hashCode(this._protocol);
            result = 31 * result + Objects.hashCode(this._remotePortHigh);
            result = 31 * result + Objects.hashCode(this._remotePortLow);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ApplicationData.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ApplicationData other = (ApplicationData)obj;
            if (!Objects.equals(this._address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(this._ipTos, other.getIpTos())) {
                return false;
            }
            if (!Objects.equals(this._localPortHigh, other.getLocalPortHigh())) {
                return false;
            }
            if (!Objects.equals(this._localPortLow, other.getLocalPortLow())) {
                return false;
            }
            if (!Objects.equals(this._protocol, other.getProtocol())) {
                return false;
            }
            if (!Objects.equals(this._remotePortHigh, other.getRemotePortHigh())) {
                return false;
            }
            if (!Objects.equals(this._remotePortLow, other.getRemotePortLow())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ApplicationDataImpl otherImpl = (ApplicationDataImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ApplicationData>>, Augmentation<ApplicationData>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ApplicationData");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_address", (Object)this._address);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ipTos", (Object)this._ipTos);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_localPortHigh", (Object)this._localPortHigh);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_localPortLow", (Object)this._localPortLow);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_protocol", (Object)this._protocol);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_remotePortHigh", (Object)this._remotePortHigh);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_remotePortLow", (Object)this._remotePortLow);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

